/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics.event;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.gobblin.metrics.GobblinTrackingEvent;
import org.apache.gobblin.metrics.MetricContext;

public class GobblinEventBuilder {
    public static final String NAMESPACE = "gobblin.event";
    public static final String EVENT_TYPE = "eventType";
    protected final String name;
    protected final String namespace;
    protected final Map<String, String> metadata;

    public GobblinEventBuilder(String name) {
        this(name, NAMESPACE);
    }

    public GobblinEventBuilder(String name, String namespace) {
        this.name = name;
        this.namespace = namespace;
        this.metadata = Maps.newHashMap();
    }

    public ImmutableMap<String, String> getMetadata() {
        return new ImmutableMap.Builder().putAll(this.metadata).build();
    }

    public void addMetadata(String key, String value) {
        this.metadata.put(key, value);
    }

    public void addAdditionalMetadata(Map<String, String> additionalMetadata) {
        this.metadata.putAll(additionalMetadata);
    }

    public GobblinTrackingEvent build() {
        return new GobblinTrackingEvent(0L, this.namespace, this.name, this.metadata);
    }

    public void submit(MetricContext context) {
        context.submitEvent(this.build());
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }
}

