/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics.context.filter;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.gobblin.metrics.InnerMetricContext;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.RootMetricContext;
import org.apache.gobblin.metrics.context.filter.ContextFilter;

public class AllContextFilter
implements ContextFilter {
    @Override
    public Set<MetricContext> getMatchingContexts() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        this.addContextsRecursively((ImmutableSet.Builder<MetricContext>)builder, RootMetricContext.get());
        return builder.build();
    }

    @Override
    public boolean matches(MetricContext metricContext) {
        return true;
    }

    @Override
    public boolean shouldReplaceByParent(InnerMetricContext removedMetricContext) {
        return false;
    }

    private void addContextsRecursively(ImmutableSet.Builder<MetricContext> builder, MetricContext metricContext) {
        builder.add((Object)metricContext);
        for (MetricContext context : metricContext.getChildContextsAsMap().values()) {
            this.addContextsRecursively(builder, context);
        }
    }
}

