/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.Timer;
import org.apache.gobblin.metrics.ContextAwareCounter;
import org.apache.gobblin.metrics.ContextAwareHistogram;
import org.apache.gobblin.metrics.ContextAwareMeter;
import org.apache.gobblin.metrics.ContextAwareMetric;
import org.apache.gobblin.metrics.ContextAwareMetricFactoryArgs;
import org.apache.gobblin.metrics.ContextAwareTimer;
import org.apache.gobblin.metrics.MetricContext;

public interface ContextAwareMetricFactory<T extends ContextAwareMetric> {
    public static final ContextAwareMetricFactory<ContextAwareCounter> DEFAULT_CONTEXT_AWARE_COUNTER_FACTORY = new ContextAwareCounterFactory();
    public static final ContextAwareMetricFactory<ContextAwareMeter> DEFAULT_CONTEXT_AWARE_METER_FACTORY = new ContextAwareMeterFactory();
    public static final ContextAwareMetricFactory<ContextAwareHistogram> DEFAULT_CONTEXT_AWARE_HISTOGRAM_FACTORY = new ContextAwareHistogramFactory();
    public static final ContextAwareMetricFactory<ContextAwareTimer> DEFAULT_CONTEXT_AWARE_TIMER_FACTORY = new ContextAwareTimerFactory();

    public T newMetric(MetricContext var1, String var2);

    default public T newMetric(ContextAwareMetricFactoryArgs args) {
        return null;
    }

    public boolean isInstance(Metric var1);

    public static class ContextAwareTimerFactory
    implements ContextAwareMetricFactory<ContextAwareTimer> {
        @Override
        public ContextAwareTimer newMetric(MetricContext context, String name) {
            return new ContextAwareTimer(context, name);
        }

        @Override
        public ContextAwareTimer newMetric(ContextAwareMetricFactoryArgs args) {
            if (args instanceof ContextAwareMetricFactoryArgs.SlidingTimeWindowArgs) {
                ContextAwareMetricFactoryArgs.SlidingTimeWindowArgs windowArgs = (ContextAwareMetricFactoryArgs.SlidingTimeWindowArgs)args;
                return new ContextAwareTimer(windowArgs.getContext(), windowArgs.getName(), windowArgs.getWindowSize(), windowArgs.getUnit());
            }
            throw new UnsupportedOperationException("Unknown factory arguments to create ContextAwareTimer");
        }

        @Override
        public boolean isInstance(Metric metric) {
            return Timer.class.isInstance(metric);
        }
    }

    public static class ContextAwareHistogramFactory
    implements ContextAwareMetricFactory<ContextAwareHistogram> {
        @Override
        public ContextAwareHistogram newMetric(MetricContext context, String name) {
            return new ContextAwareHistogram(context, name);
        }

        @Override
        public ContextAwareHistogram newMetric(ContextAwareMetricFactoryArgs args) {
            if (args instanceof ContextAwareMetricFactoryArgs.SlidingTimeWindowArgs) {
                ContextAwareMetricFactoryArgs.SlidingTimeWindowArgs windowArgs = (ContextAwareMetricFactoryArgs.SlidingTimeWindowArgs)args;
                return new ContextAwareHistogram(windowArgs.getContext(), windowArgs.getName(), windowArgs.getWindowSize(), windowArgs.getUnit());
            }
            throw new UnsupportedOperationException("Unknown factory arguments to create ContextAwareHistogram");
        }

        @Override
        public boolean isInstance(Metric metric) {
            return Histogram.class.isInstance(metric);
        }
    }

    public static class ContextAwareMeterFactory
    implements ContextAwareMetricFactory<ContextAwareMeter> {
        @Override
        public ContextAwareMeter newMetric(MetricContext context, String name) {
            return new ContextAwareMeter(context, name);
        }

        @Override
        public boolean isInstance(Metric metric) {
            return Meter.class.isInstance(metric);
        }
    }

    public static class ContextAwareCounterFactory
    implements ContextAwareMetricFactory<ContextAwareCounter> {
        @Override
        public ContextAwareCounter newMetric(MetricContext context, String name) {
            return new ContextAwareCounter(context, name);
        }

        @Override
        public boolean isInstance(Metric metric) {
            return Counter.class.isInstance(metric);
        }
    }
}

