/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics;

import com.codahale.metrics.ExponentiallyDecayingReservoir;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.SlidingTimeWindowReservoir;
import com.codahale.metrics.Snapshot;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.metrics.ContextAwareMetric;
import org.apache.gobblin.metrics.InnerHistogram;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.metric.InnerMetric;

public class ContextAwareHistogram
extends Histogram
implements ContextAwareMetric {
    private final InnerHistogram innerHistogram;
    private final MetricContext context;

    ContextAwareHistogram(MetricContext context, String name) {
        super((Reservoir)new ExponentiallyDecayingReservoir());
        this.innerHistogram = new InnerHistogram(context, name, this);
        this.context = context;
    }

    ContextAwareHistogram(MetricContext context, String name, long windowSize, TimeUnit unit) {
        super((Reservoir)new SlidingTimeWindowReservoir(windowSize, unit));
        this.innerHistogram = new InnerHistogram(context, name, this, windowSize, unit);
        this.context = context;
    }

    @Override
    public MetricContext getContext() {
        return this.context;
    }

    @Override
    public InnerMetric getInnerMetric() {
        return this.innerHistogram;
    }

    public void update(int value) {
        this.innerHistogram.update(value);
    }

    public void update(long value) {
        this.innerHistogram.update(value);
    }

    @Override
    public String getName() {
        return this.innerHistogram.getName();
    }

    public ContextAwareMetric getContextAwareMetric() {
        return this.innerHistogram.getContextAwareMetric();
    }

    public long getCount() {
        return this.innerHistogram.getCount();
    }

    public Snapshot getSnapshot() {
        return this.innerHistogram.getSnapshot();
    }
}

