/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.config.client;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.gobblin.config.store.api.ConfigStoreFactory;
import org.apache.log4j.Logger;

public class ConfigStoreFactoryRegister {
    private static final Logger LOG = Logger.getLogger(ConfigStoreFactoryRegister.class);
    private final Map<String, ConfigStoreFactory> configStoreFactoryMap = new HashMap<String, ConfigStoreFactory>();

    public ConfigStoreFactoryRegister() {
        ServiceLoader<ConfigStoreFactory> loader = ServiceLoader.load(ConfigStoreFactory.class);
        for (ConfigStoreFactory f : loader) {
            this.configStoreFactoryMap.put(f.getScheme(), f);
            LOG.info((Object)("Created the config store factory with scheme name " + f.getScheme()));
        }
    }

    public ConfigStoreFactory getConfigStoreFactory(String scheme) {
        return this.configStoreFactoryMap.get(scheme);
    }

    public void register(ConfigStoreFactory factory) {
        this.configStoreFactoryMap.put(factory.getScheme(), factory);
        LOG.info((Object)("Registered the config store factory with scheme name " + factory.getScheme()));
    }
}

