/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.config.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.ArrayListMultimap;
import com.typesafe.config.Config;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.gobblin.config.client.ConfigClientUtils;
import org.apache.gobblin.config.client.ConfigStoreFactoryRegister;
import org.apache.gobblin.config.client.api.ConfigStoreFactoryDoesNotExistsException;
import org.apache.gobblin.config.client.api.VersionStabilityPolicy;
import org.apache.gobblin.config.common.impl.ConfigStoreBackedTopology;
import org.apache.gobblin.config.common.impl.ConfigStoreBackedValueInspector;
import org.apache.gobblin.config.common.impl.ConfigStoreTopologyInspector;
import org.apache.gobblin.config.common.impl.ConfigStoreValueInspector;
import org.apache.gobblin.config.common.impl.InMemoryTopology;
import org.apache.gobblin.config.common.impl.InMemoryValueInspector;
import org.apache.gobblin.config.store.api.ConfigKeyPath;
import org.apache.gobblin.config.store.api.ConfigStore;
import org.apache.gobblin.config.store.api.ConfigStoreCreationException;
import org.apache.gobblin.config.store.api.ConfigStoreFactory;
import org.apache.gobblin.config.store.api.ConfigStoreWithStableVersioning;
import org.apache.gobblin.config.store.api.VersionDoesNotExistException;
import org.apache.log4j.Logger;

public class ConfigClient {
    private static final Logger LOG = Logger.getLogger(ConfigClient.class);
    private final VersionStabilityPolicy policy;
    private final TreeMap<URI, ConfigStoreAccessor> configStoreAccessorMap = new TreeMap();
    private final ConfigStoreFactoryRegister configStoreFactoryRegister;

    private ConfigClient(VersionStabilityPolicy policy) {
        this(policy, new ConfigStoreFactoryRegister());
    }

    @VisibleForTesting
    ConfigClient(VersionStabilityPolicy policy, ConfigStoreFactoryRegister register) {
        this.policy = policy;
        this.configStoreFactoryRegister = register;
    }

    public static ConfigClient createConfigClient(VersionStabilityPolicy policy) {
        return new ConfigClient(policy);
    }

    public Config getConfig(URI configKeyUri) throws ConfigStoreFactoryDoesNotExistsException, ConfigStoreCreationException, VersionDoesNotExistException {
        return this.getConfig(configKeyUri, (Optional<Config>)Optional.absent());
    }

    public Config getConfig(URI configKeyUri, Optional<Config> runtimeConfig) throws ConfigStoreFactoryDoesNotExistsException, ConfigStoreCreationException, VersionDoesNotExistException {
        ConfigStoreAccessor accessor = this.getConfigStoreAccessor(configKeyUri);
        ConfigKeyPath configKeypath = ConfigClientUtils.buildConfigKeyPath(configKeyUri, accessor.configStore);
        return accessor.valueInspector.getResolvedConfig(configKeypath, runtimeConfig);
    }

    public Map<URI, Config> getConfigs(Collection<URI> configKeyUris) throws ConfigStoreFactoryDoesNotExistsException, ConfigStoreCreationException, VersionDoesNotExistException {
        if (configKeyUris == null || configKeyUris.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap<URI, Config> result = new HashMap<URI, Config>();
        ArrayListMultimap partitionedAccessor = ArrayListMultimap.create();
        HashMap reverseMap = new HashMap();
        for (URI uRI : configKeyUris) {
            ConfigStoreAccessor accessor = this.getConfigStoreAccessor(uRI);
            ConfigKeyPath configKeypath = ConfigClientUtils.buildConfigKeyPath(uRI, accessor.configStore);
            partitionedAccessor.put((Object)accessor, (Object)configKeypath);
            if (!reverseMap.containsKey(accessor)) {
                reverseMap.put(accessor, new HashMap());
            }
            ((Map)reverseMap.get(accessor)).put(configKeypath, uRI);
        }
        for (Map.Entry entry : partitionedAccessor.asMap().entrySet()) {
            Map batchResult = ((ConfigStoreAccessor)entry.getKey()).valueInspector.getResolvedConfigs((Collection)entry.getValue());
            for (Map.Entry resultEntry : batchResult.entrySet()) {
                URI orgURI = (URI)((Map)reverseMap.get(entry.getKey())).get(resultEntry.getKey());
                result.put(orgURI, (Config)resultEntry.getValue());
            }
        }
        return result;
    }

    public Config getConfig(String configKeyStr) throws ConfigStoreFactoryDoesNotExistsException, ConfigStoreCreationException, VersionDoesNotExistException, URISyntaxException {
        return this.getConfig(configKeyStr, (Optional<Config>)Optional.absent());
    }

    public Config getConfig(String configKeyStr, Optional<Config> runtimeConfig) throws ConfigStoreFactoryDoesNotExistsException, ConfigStoreCreationException, VersionDoesNotExistException, URISyntaxException {
        return this.getConfig(new URI(configKeyStr), runtimeConfig);
    }

    public Map<URI, Config> getConfigsFromStrings(Collection<String> configKeyStrs) throws ConfigStoreFactoryDoesNotExistsException, ConfigStoreCreationException, VersionDoesNotExistException, URISyntaxException {
        if (configKeyStrs == null || configKeyStrs.size() == 0) {
            return Collections.emptyMap();
        }
        ArrayList<URI> configKeyUris = new ArrayList<URI>();
        for (String s : configKeyStrs) {
            configKeyUris.add(new URI(s));
        }
        return this.getConfigs(configKeyUris);
    }

    public Collection<URI> getImports(URI configKeyUri, boolean recursive) throws ConfigStoreFactoryDoesNotExistsException, ConfigStoreCreationException, VersionDoesNotExistException {
        return this.getImports(configKeyUri, recursive, (Optional<Config>)Optional.absent());
    }

    public Collection<URI> getImports(URI configKeyUri, boolean recursive, Optional<Config> runtimeConfig) throws ConfigStoreFactoryDoesNotExistsException, ConfigStoreCreationException, VersionDoesNotExistException {
        ConfigStoreAccessor accessor = this.getConfigStoreAccessor(configKeyUri);
        ConfigKeyPath configKeypath = ConfigClientUtils.buildConfigKeyPath(configKeyUri, accessor.configStore);
        List result = !recursive ? accessor.topologyInspector.getOwnImports(configKeypath, runtimeConfig) : accessor.topologyInspector.getImportsRecursively(configKeypath, runtimeConfig);
        return ConfigClientUtils.buildUriInClientFormat(result, accessor.configStore, configKeyUri.getAuthority() != null);
    }

    public Collection<URI> getImportedBy(URI configKeyUri, boolean recursive) throws ConfigStoreFactoryDoesNotExistsException, ConfigStoreCreationException, VersionDoesNotExistException {
        return this.getImportedBy(configKeyUri, recursive, (Optional<Config>)Optional.absent());
    }

    public Collection<URI> getImportedBy(URI configKeyUri, boolean recursive, Optional<Config> runtimeConfig) throws ConfigStoreFactoryDoesNotExistsException, ConfigStoreCreationException, VersionDoesNotExistException {
        ConfigStoreAccessor accessor = this.getConfigStoreAccessor(configKeyUri);
        ConfigKeyPath configKeypath = ConfigClientUtils.buildConfigKeyPath(configKeyUri, accessor.configStore);
        Collection result = !recursive ? accessor.topologyInspector.getImportedBy(configKeypath, runtimeConfig) : accessor.topologyInspector.getImportedByRecursively(configKeypath, runtimeConfig);
        return ConfigClientUtils.buildUriInClientFormat(result, accessor.configStore, configKeyUri.getAuthority() != null);
    }

    private URI getMatchedFloorKeyFromCache(URI configKeyURI) {
        URI floorKey = this.configStoreAccessorMap.floorKey(configKeyURI);
        if (floorKey == null) {
            return null;
        }
        if (ConfigClientUtils.isAncestorOrSame(configKeyURI, floorKey)) {
            return floorKey;
        }
        return null;
    }

    private ConfigStoreAccessor createNewConfigStoreAccessor(URI configKeyURI) throws ConfigStoreFactoryDoesNotExistsException, ConfigStoreCreationException, VersionDoesNotExistException {
        ConfigStoreAccessor result;
        LOG.info((Object)("Create new config store accessor for URI " + configKeyURI));
        ConfigStoreFactory<ConfigStore> csFactory = this.getConfigStoreFactory(configKeyURI);
        ConfigStore cs = csFactory.createConfigStore(configKeyURI);
        if (!ConfigClient.isConfigStoreWithStableVersion(cs) && this.policy == VersionStabilityPolicy.CROSS_JVM_STABILITY) {
            throw new RuntimeException(String.format("with policy set to %s, can not connect to unstable config store %s", VersionStabilityPolicy.CROSS_JVM_STABILITY, cs.getStoreURI()));
        }
        String currentVersion = cs.getCurrentVersion();
        LOG.info((Object)("Current config store version number: " + currentVersion));
        ConfigStoreBackedTopology csTopology = new ConfigStoreBackedTopology(cs, currentVersion);
        InMemoryTopology inMemoryTopology = new InMemoryTopology((ConfigStoreTopologyInspector)csTopology);
        ConfigStoreBackedValueInspector rawValueInspector = new ConfigStoreBackedValueInspector(cs, currentVersion, (ConfigStoreTopologyInspector)inMemoryTopology);
        if (ConfigClient.isConfigStoreWithStableVersion(cs) || this.policy == VersionStabilityPolicy.WEAK_LOCAL_STABILITY) {
            InMemoryValueInspector inMemoryValueInspector = new InMemoryValueInspector((ConfigStoreValueInspector)rawValueInspector, false);
            result = new ConfigStoreAccessor(cs, (ConfigStoreValueInspector)inMemoryValueInspector, (ConfigStoreTopologyInspector)inMemoryTopology);
        } else if (this.policy == VersionStabilityPolicy.STRONG_LOCAL_STABILITY) {
            InMemoryValueInspector inMemoryValueInspector = new InMemoryValueInspector((ConfigStoreValueInspector)rawValueInspector, true);
            result = new ConfigStoreAccessor(cs, (ConfigStoreValueInspector)inMemoryValueInspector, (ConfigStoreTopologyInspector)inMemoryTopology);
        } else {
            result = new ConfigStoreAccessor(cs, (ConfigStoreValueInspector)rawValueInspector, (ConfigStoreTopologyInspector)inMemoryTopology);
        }
        return result;
    }

    private static boolean isConfigStoreWithStableVersion(ConfigStore cs) {
        for (Annotation annotation : cs.getClass().getDeclaredAnnotations()) {
            if (!(annotation instanceof ConfigStoreWithStableVersioning)) continue;
            return true;
        }
        return false;
    }

    private ConfigStoreAccessor getConfigStoreAccessor(URI configKeyURI) throws ConfigStoreFactoryDoesNotExistsException, ConfigStoreCreationException, VersionDoesNotExistException {
        URI matchedFloorKey = this.getMatchedFloorKeyFromCache(configKeyURI);
        if (matchedFloorKey != null) {
            ConfigStoreAccessor result = this.configStoreAccessorMap.get(matchedFloorKey);
            return result;
        }
        ConfigStoreAccessor result = this.createNewConfigStoreAccessor(configKeyURI);
        ConfigStore cs = result.configStore;
        if (configKeyURI.getAuthority() == null) {
            try {
                this.configStoreAccessorMap.put(new URI(configKeyURI.getScheme(), null, "/", null, null), result);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Can not build URI based on " + configKeyURI);
            }
        } else if (!ConfigClientUtils.isAncestorOrSame(configKeyURI, cs.getStoreURI())) {
            throw new RuntimeException(String.format("Config Store root URI %s is not the prefix of input %s", cs.getStoreURI(), configKeyURI));
        }
        this.configStoreAccessorMap.put(cs.getStoreURI(), result);
        return result;
    }

    private ConfigStoreFactory<ConfigStore> getConfigStoreFactory(URI configKeyUri) throws ConfigStoreFactoryDoesNotExistsException {
        ConfigStoreFactory csf = this.configStoreFactoryRegister.getConfigStoreFactory(configKeyUri.getScheme());
        if (csf == null) {
            throw new ConfigStoreFactoryDoesNotExistsException(configKeyUri.getScheme(), "scheme name does not exists");
        }
        return csf;
    }

    static class ConfigStoreAccessor {
        final ConfigStore configStore;
        final ConfigStoreValueInspector valueInspector;
        final ConfigStoreTopologyInspector topologyInspector;

        ConfigStoreAccessor(ConfigStore cs, ConfigStoreValueInspector valueInspector, ConfigStoreTopologyInspector topologyInspector) {
            this.configStore = cs;
            this.valueInspector = valueInspector;
            this.topologyInspector = topologyInspector;
        }
    }
}

