/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metastore.util;

import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.commons.lang.StringUtils;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationInfoService;
import org.flywaydb.core.internal.info.MigrationInfoDumper;

public class DatabaseJobHistoryStoreSchemaManager
implements Closeable {
    private final Flyway flyway = new Flyway();

    private DatabaseJobHistoryStoreSchemaManager(Properties properties) {
        this.flyway.configure(properties);
        this.flyway.setClassLoader(this.getClass().getClassLoader());
    }

    public static DataSourceBuilder builder() {
        return new Builder();
    }

    private static FinalBuilder builder(Properties properties) {
        return new Builder(properties);
    }

    public void migrate() throws FlywayException {
        this.flyway.migrate();
    }

    public void info() throws FlywayException {
        MigrationInfoService info = this.flyway.info();
        System.out.println(MigrationInfoDumper.dumpToAsciiTable((MigrationInfo[])info.all()));
    }

    @Override
    public void close() throws IOException {
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 1 || args.length > 2) {
            DatabaseJobHistoryStoreSchemaManager.printUsage();
        }
        try (Closer closer = Closer.create();){
            CompositeConfiguration config = new CompositeConfiguration();
            config.addConfiguration((Configuration)new SystemConfiguration());
            if (args.length == 2) {
                config.addConfiguration((Configuration)new PropertiesConfiguration(args[1]));
            }
            Properties properties = DatabaseJobHistoryStoreSchemaManager.getProperties((Configuration)config);
            DatabaseJobHistoryStoreSchemaManager schemaManager = (DatabaseJobHistoryStoreSchemaManager)closer.register((Closeable)DatabaseJobHistoryStoreSchemaManager.builder(properties).build());
            if (String.CASE_INSENSITIVE_ORDER.compare("migrate", args[0]) == 0) {
                schemaManager.migrate();
            } else if (String.CASE_INSENSITIVE_ORDER.compare("info", args[0]) == 0) {
                schemaManager.info();
            } else {
                DatabaseJobHistoryStoreSchemaManager.printUsage();
            }
        }
    }

    private static void printUsage() {
        System.err.println("Usage: migrate|info [configuration file]");
        System.exit(1);
    }

    private static Properties getProperties(Configuration config) {
        Properties props = new Properties();
        char delimiter = config instanceof AbstractConfiguration ? (char)((AbstractConfiguration)config).getListDelimiter() : (char)',';
        Iterator keys = config.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            List list = config.getList(key);
            props.setProperty("flyway." + key, StringUtils.join(list.iterator(), (char)delimiter));
        }
        return props;
    }

    private static class Builder
    implements DataSourceBuilder,
    VersionBuilder,
    FinalBuilder {
        private final Properties properties;

        public Builder() {
            this.properties = new Properties();
        }

        public Builder(Properties properties) {
            this.properties = properties;
        }

        @Override
        public DatabaseJobHistoryStoreSchemaManager build() {
            return new DatabaseJobHistoryStoreSchemaManager(this.properties);
        }

        @Override
        public VersionBuilder setDataSource(String url, String user, String password) {
            this.properties.setProperty("flyway.url", url);
            this.properties.setProperty("flyway.user", user);
            this.properties.setProperty("flyway.password", password);
            return this;
        }

        @Override
        public FinalBuilder setVersion(String version) {
            if (!"latest".equalsIgnoreCase(version)) {
                this.properties.setProperty("flyway.target", version);
            }
            return this;
        }
    }

    public static interface FinalBuilder {
        public DatabaseJobHistoryStoreSchemaManager build();
    }

    public static interface VersionBuilder
    extends FinalBuilder {
        public FinalBuilder setVersion(String var1);
    }

    public static interface DataSourceBuilder {
        public VersionBuilder setDataSource(String var1, String var2, String var3);
    }
}

