/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metastore.metadata;

import java.beans.ConstructorProperties;
import java.io.IOException;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.metastore.StateStore;

public abstract class StateStoreEntryManager<T extends State> {
    private final String storeName;
    private final String tableName;
    private final long timestamp;
    private final StateStore stateStore;

    public final long getTimestamp() {
        if (this.timestamp <= 0L) {
            throw new RuntimeException("Timestamp is not reliable.");
        }
        return this.timestamp;
    }

    public abstract T readState() throws IOException;

    public abstract void delete() throws IOException;

    @ConstructorProperties(value={"storeName", "tableName", "timestamp", "stateStore"})
    public StateStoreEntryManager(String storeName, String tableName, long timestamp, StateStore stateStore) {
        this.storeName = storeName;
        this.tableName = tableName;
        this.timestamp = timestamp;
        this.stateStore = stateStore;
    }

    public String getStoreName() {
        return this.storeName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public StateStore getStateStore() {
        return this.stateStore;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StateStoreEntryManager)) {
            return false;
        }
        StateStoreEntryManager other = (StateStoreEntryManager)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$storeName = this.getStoreName();
        String other$storeName = other.getStoreName();
        if (this$storeName == null ? other$storeName != null : !this$storeName.equals(other$storeName)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        StateStore this$stateStore = this.getStateStore();
        StateStore other$stateStore = other.getStateStore();
        return !(this$stateStore == null ? other$stateStore != null : !this$stateStore.equals(other$stateStore));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StateStoreEntryManager;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $storeName = this.getStoreName();
        result = result * 59 + ($storeName == null ? 43 : $storeName.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        StateStore $stateStore = this.getStateStore();
        result = result * 59 + ($stateStore == null ? 43 : $stateStore.hashCode());
        return result;
    }

    public String toString() {
        return "StateStoreEntryManager(storeName=" + this.getStoreName() + ", tableName=" + this.getTableName() + ", timestamp=" + this.getTimestamp() + ", stateStore=" + this.getStateStore() + ")";
    }
}

