/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metastore;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.metastore.StateStore;
import org.apache.gobblin.util.HadoopUtils;
import org.apache.gobblin.util.WritableShimSerialization;
import org.apache.gobblin.util.hadoop.GobblinSequenceFileReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;

public class FsStateStore<T extends State>
implements StateStore<T> {
    public static final String TMP_FILE_PREFIX = "_tmp_";
    protected final Configuration conf;
    protected final FileSystem fs;
    protected boolean useTmpFileForPut;
    protected final String storeRootDir;
    private final Class<T> stateClass;

    public FsStateStore(String fsUri, String storeRootDir, Class<T> stateClass) throws IOException {
        this.conf = this.getConf(null);
        this.fs = FileSystem.get((URI)URI.create(fsUri), (Configuration)this.conf);
        this.useTmpFileForPut = !HadoopUtils.FS_SCHEMES_NON_ATOMIC.contains(this.fs.getUri().getScheme());
        this.storeRootDir = storeRootDir;
        this.stateClass = stateClass;
    }

    private Configuration getConf(Configuration otherConf) {
        Configuration conf = otherConf == null ? new Configuration() : new Configuration(otherConf);
        WritableShimSerialization.addToHadoopConfiguration((Configuration)conf);
        return conf;
    }

    public FsStateStore(FileSystem fs, String storeRootDir, Class<T> stateClass) {
        this.fs = fs;
        this.useTmpFileForPut = !HadoopUtils.FS_SCHEMES_NON_ATOMIC.contains(this.fs.getUri().getScheme());
        this.conf = this.getConf(this.fs.getConf());
        this.storeRootDir = storeRootDir;
        this.stateClass = stateClass;
    }

    public FsStateStore(String storeUrl, Class<T> stateClass) throws IOException {
        this.conf = this.getConf(null);
        Path storePath = new Path(storeUrl);
        this.fs = storePath.getFileSystem(this.conf);
        this.useTmpFileForPut = !HadoopUtils.FS_SCHEMES_NON_ATOMIC.contains(this.fs.getUri().getScheme());
        this.storeRootDir = storePath.toUri().getPath();
        this.stateClass = stateClass;
    }

    @Override
    public boolean create(String storeName) throws IOException {
        Path storePath = new Path(this.storeRootDir, storeName);
        return this.fs.exists(storePath) || this.fs.mkdirs(storePath, new FsPermission(493));
    }

    @Override
    public boolean create(String storeName, String tableName) throws IOException {
        Path storePath = new Path(this.storeRootDir, storeName);
        if (!this.fs.exists(storePath) && !this.create(storeName)) {
            return false;
        }
        Path tablePath = new Path(storePath, tableName);
        if (this.fs.exists(tablePath)) {
            throw new IOException(String.format("State file %s already exists for table %s", tablePath, tableName));
        }
        return this.fs.createNewFile(tablePath);
    }

    @Override
    public boolean exists(String storeName, String tableName) throws IOException {
        Path tablePath = new Path(new Path(this.storeRootDir, storeName), tableName);
        return this.fs.exists(tablePath);
    }

    @Override
    public void put(String storeName, String tableName, T state) throws IOException {
        String tmpTableName = this.useTmpFileForPut ? TMP_FILE_PREFIX + tableName : tableName;
        Path tmpTablePath = new Path(new Path(this.storeRootDir, storeName), tmpTableName);
        if (!this.fs.exists(tmpTablePath) && !this.create(storeName, tmpTableName)) {
            throw new IOException("Failed to create a state file for table " + tmpTableName);
        }
        try (Closer closer = Closer.create();){
            SequenceFile.Writer writer = (SequenceFile.Writer)closer.register((Closeable)SequenceFile.createWriter((FileSystem)this.fs, (Configuration)this.conf, (Path)tmpTablePath, Text.class, this.stateClass, (SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK, (CompressionCodec)new DefaultCodec()));
            writer.append((Object)new Text(Strings.nullToEmpty((String)state.getId())), state);
        }
        if (this.useTmpFileForPut) {
            Path tablePath = new Path(new Path(this.storeRootDir, storeName), tableName);
            HadoopUtils.renamePath((FileSystem)this.fs, (Path)tmpTablePath, (Path)tablePath);
        }
    }

    @Override
    public void putAll(String storeName, String tableName, Collection<T> states) throws IOException {
        String tmpTableName = this.useTmpFileForPut ? TMP_FILE_PREFIX + tableName : tableName;
        Path tmpTablePath = new Path(new Path(this.storeRootDir, storeName), tmpTableName);
        if (!this.fs.exists(tmpTablePath) && !this.create(storeName, tmpTableName)) {
            throw new IOException("Failed to create a state file for table " + tmpTableName);
        }
        try (Closer closer = Closer.create();){
            SequenceFile.Writer writer = (SequenceFile.Writer)closer.register((Closeable)SequenceFile.createWriter((FileSystem)this.fs, (Configuration)this.conf, (Path)tmpTablePath, Text.class, this.stateClass, (SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK, (CompressionCodec)new DefaultCodec()));
            for (State state : states) {
                writer.append((Object)new Text(Strings.nullToEmpty((String)state.getId())), (Object)state);
            }
        }
        if (this.useTmpFileForPut) {
            Path tablePath = new Path(new Path(this.storeRootDir, storeName), tableName);
            HadoopUtils.renamePath((FileSystem)this.fs, (Path)tmpTablePath, (Path)tablePath);
        }
    }

    @Override
    public T get(String storeName, String tableName, String stateId) throws IOException {
        Path tablePath = new Path(new Path(this.storeRootDir, storeName), tableName);
        if (!this.fs.exists(tablePath)) {
            return null;
        }
        try (Closer closer = Closer.create();){
            State state;
            GobblinSequenceFileReader reader = (GobblinSequenceFileReader)closer.register((Closeable)new GobblinSequenceFileReader(this.fs, tablePath, this.conf));
            try {
                Text key = new Text();
                State state2 = (State)this.stateClass.newInstance();
                while (reader.next((Writable)key)) {
                    state2 = (State)reader.getCurrentValue((Object)state2);
                    if (!key.toString().equals(stateId)) continue;
                    state = state2;
                }
            }
            catch (Exception e) {
                throw new IOException("failure retrieving state from storeName " + storeName + " tableName " + tableName, e);
            }
            return (T)state;
        }
        return null;
    }

    @Override
    public List<T> getAll(String storeName, String tableName) throws IOException {
        ArrayList states = Lists.newArrayList();
        Path tablePath = new Path(new Path(this.storeRootDir, storeName), tableName);
        if (!this.fs.exists(tablePath)) {
            return states;
        }
        try (Closer closer = Closer.create();){
            GobblinSequenceFileReader reader = (GobblinSequenceFileReader)closer.register((Closeable)new GobblinSequenceFileReader(this.fs, tablePath, this.conf));
            try {
                Text key = new Text();
                State state = (State)this.stateClass.newInstance();
                while (reader.next((Writable)key)) {
                    state = (State)reader.getCurrentValue((Object)state);
                    states.add(state);
                    state = (State)this.stateClass.newInstance();
                }
            }
            catch (Exception e) {
                throw new IOException("failure retrieving state from storeName " + storeName + " tableName " + tableName, e);
            }
        }
        return states;
    }

    @Override
    public List<T> getAll(String storeName) throws IOException {
        ArrayList states = Lists.newArrayList();
        Path storePath = new Path(this.storeRootDir, storeName);
        if (!this.fs.exists(storePath)) {
            return states;
        }
        for (FileStatus status : this.fs.listStatus(storePath)) {
            states.addAll(this.getAll(storeName, status.getPath().getName()));
        }
        return states;
    }

    @Override
    public List<String> getTableNames(String storeName, Predicate<String> predicate) throws IOException {
        ArrayList names = Lists.newArrayList();
        Path storePath = new Path(this.storeRootDir, storeName);
        if (!this.fs.exists(storePath)) {
            return names;
        }
        for (FileStatus status : this.fs.listStatus(storePath)) {
            if (!predicate.apply((Object)status.getPath().getName())) continue;
            names.add(status.getPath().getName());
        }
        return names;
    }

    @Override
    public void createAlias(String storeName, String original, String alias) throws IOException {
        Path originalTablePath = new Path(new Path(this.storeRootDir, storeName), original);
        if (!this.fs.exists(originalTablePath)) {
            throw new IOException(String.format("State file %s does not exist for table %s", originalTablePath, original));
        }
        Path aliasTablePath = new Path(new Path(this.storeRootDir, storeName), alias);
        Path tmpAliasTablePath = new Path(aliasTablePath.getParent(), new Path(TMP_FILE_PREFIX, aliasTablePath.getName()));
        HadoopUtils.copyFile((FileSystem)this.fs, (Path)originalTablePath, (FileSystem)this.fs, (Path)aliasTablePath, (Path)tmpAliasTablePath, (boolean)true, (Configuration)this.conf);
    }

    @Override
    public void delete(String storeName, String tableName) throws IOException {
        Path tablePath = new Path(new Path(this.storeRootDir, storeName), tableName);
        if (this.fs.exists(tablePath)) {
            this.fs.delete(tablePath, false);
        }
    }

    @Override
    public void delete(String storeName) throws IOException {
        Path storePath = new Path(this.storeRootDir, storeName);
        if (this.fs.exists(storePath)) {
            this.fs.delete(storePath, true);
        }
    }
}

