/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metastore;

import com.google.common.base.Predicate;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.gobblin.dataset.DatasetsFinder;
import org.apache.gobblin.metastore.DatasetStateStore;
import org.apache.gobblin.metastore.DatasetStoreDataset;
import org.apache.gobblin.metastore.metadata.DatasetStateStoreEntryManager;
import org.apache.gobblin.metastore.metadata.StateStoreEntryManager;
import org.apache.gobblin.metastore.predicates.DatasetPredicate;
import org.apache.gobblin.metastore.predicates.StateStorePredicate;
import org.apache.gobblin.metastore.predicates.StoreNamePredicate;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class DatasetStoreDatasetFinder
implements DatasetsFinder<DatasetStoreDataset> {
    public static final String STORE_NAME_FILTER = "datasetStoreDatasetFinder.filter.storeName";
    public static final String DATASET_URN_FILTER = "datasetStoreDatasetFinder.filter.datasetUrn";
    private final Config config;
    private final DatasetStateStore store;
    private final StateStorePredicate predicate;

    public DatasetStoreDatasetFinder(FileSystem fs, Properties props) throws IOException {
        this.config = ConfigFactory.parseProperties((Properties)props);
        this.store = DatasetStateStore.buildDatasetStateStore(this.config);
        this.predicate = this.buildPredicate();
    }

    public DatasetStoreDatasetFinder(Properties props) throws IOException {
        this(FileSystem.get((Configuration)new Configuration()), props);
    }

    private StateStorePredicate buildPredicate() {
        StateStorePredicate predicate = null;
        String storeName = null;
        if (ConfigUtils.hasNonEmptyPath((Config)this.config, (String)STORE_NAME_FILTER)) {
            storeName = this.config.getString(STORE_NAME_FILTER);
            predicate = new StoreNamePredicate(storeName, (Predicate<StateStoreEntryManager>)((Predicate)x -> true));
        }
        if (ConfigUtils.hasNonEmptyPath((Config)this.config, (String)DATASET_URN_FILTER)) {
            if (storeName == null) {
                throw new IllegalArgumentException("datasetStoreDatasetFinder.filter.datasetUrn requires datasetStoreDatasetFinder.filter.storeName to also be defined.");
            }
            String datasetUrn = this.config.getString(DATASET_URN_FILTER);
            predicate = new DatasetPredicate(storeName, datasetUrn, (Predicate<StateStoreEntryManager>)((Predicate)x -> true));
        }
        return predicate == null ? new StateStorePredicate((Predicate<StateStoreEntryManager>)((Predicate)x -> true)) : predicate;
    }

    public List<DatasetStoreDataset> findDatasets() throws IOException {
        List<DatasetStateStoreEntryManager> entries = this.store.getMetadataForTables(this.predicate);
        Map<DatasetStoreDataset.Key, List<DatasetStateStoreEntryManager>> entriesGroupedByDataset = entries.stream().collect(Collectors.groupingBy(DatasetStoreDataset.Key::new));
        return entriesGroupedByDataset.entrySet().stream().map(entry -> new DatasetStoreDataset((DatasetStoreDataset.Key)entry.getKey(), (List)entry.getValue())).collect(Collectors.toList());
    }

    public Path commonDatasetRoot() {
        return null;
    }
}

