/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.codec;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.codec.binary.Base64OutputStream;
import org.apache.gobblin.codec.StreamCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Base64Codec
implements StreamCodec {
    private static final Logger log = LoggerFactory.getLogger(Base64Codec.class);
    private static Method java8GetEncoder;
    private static Method java8WrapStreamEncode;
    private static Method java8GetDecoder;
    private static Method java8WrapStreamDecode;
    private static final boolean foundJava8;
    private static boolean forceApacheBase64;

    public OutputStream encodeOutputStream(OutputStream origStream) throws IOException {
        try {
            if (this.canUseJava8()) {
                Object encoder = java8GetEncoder.invoke(null, new Object[0]);
                return (OutputStream)java8WrapStreamEncode.invoke(encoder, origStream);
            }
            return this.encodeOutputStreamWithApache(origStream);
        }
        catch (ReflectiveOperationException e) {
            log.warn("Error invoking java8 methods, falling back to Apache", (Throwable)e);
            return this.encodeOutputStreamWithApache(origStream);
        }
    }

    public InputStream decodeInputStream(InputStream origStream) throws IOException {
        try {
            if (this.canUseJava8()) {
                Object decoder = java8GetDecoder.invoke(null, new Object[0]);
                return (InputStream)java8WrapStreamDecode.invoke(decoder, origStream);
            }
            return this.decodeInputStreamWithApache(origStream);
        }
        catch (ReflectiveOperationException e) {
            log.warn("Error invoking java8 methods, falling back to Apache", (Throwable)e);
            return this.decodeInputStreamWithApache(origStream);
        }
    }

    private static Method getMethod(String className, String methodName, Class<?> ... parameterTypes) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> clazz = Class.forName(className);
        return clazz.getMethod(methodName, parameterTypes);
    }

    private OutputStream encodeOutputStreamWithApache(OutputStream origStream) {
        return new Base64OutputStream(origStream, true, 0, null);
    }

    private InputStream decodeInputStreamWithApache(InputStream origStream) {
        return new Base64InputStream(origStream);
    }

    static void forceApacheBase64() {
        forceApacheBase64 = true;
    }

    private boolean canUseJava8() {
        return !forceApacheBase64 && foundJava8;
    }

    public String getTag() {
        return "base64";
    }

    static {
        forceApacheBase64 = false;
        boolean base64Found = false;
        try {
            Class.forName("java.util.Base64");
            java8GetEncoder = Base64Codec.getMethod("java.util.Base64", "getEncoder", new Class[0]);
            java8WrapStreamEncode = Base64Codec.getMethod("java.util.Base64$Encoder", "wrap", OutputStream.class);
            java8GetDecoder = Base64Codec.getMethod("java.util.Base64", "getDecoder", new Class[0]);
            java8WrapStreamDecode = Base64Codec.getMethod("java.util.Base64$Decoder", "wrap", InputStream.class);
            base64Found = true;
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            log.info("Couldn't find java.util.Base64 or methods, falling back to Apache Commons", (Throwable)e);
            base64Found = false;
        }
        finally {
            foundJava8 = base64Found;
        }
    }
}

