/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.cluster;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import org.apache.gobblin.cluster.SingleTaskRunner;
import org.apache.gobblin.cluster.SingleTaskRunnerBuilder;
import org.apache.gobblin.cluster.SingleTaskRunnerMainOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SingleTaskRunnerMain {
    private static final Logger logger = LoggerFactory.getLogger(SingleTaskRunnerMain.class);
    private final SingleTaskRunnerBuilder builder;

    SingleTaskRunnerMain(SingleTaskRunnerBuilder builder) {
        this.builder = builder;
    }

    public static void main(String[] args) {
        logger.info("SingleTaskRunnerMain starting. args: " + Arrays.toString(args));
        SingleTaskRunnerMain runnerMain = new SingleTaskRunnerMain(new SingleTaskRunnerBuilder());
        try {
            runnerMain.run(args);
        }
        catch (Exception e) {
            logger.error("Got an exception running a single task.", (Throwable)e);
            System.exit(1);
        }
    }

    void run(String[] args) throws IOException, InterruptedException {
        OutputStreamWriter streamWriter = new OutputStreamWriter((OutputStream)System.out, Charsets.UTF_8);
        PrintWriter writer = new PrintWriter((Writer)streamWriter, true);
        SingleTaskRunnerMainOptions options = new SingleTaskRunnerMainOptions(args, writer);
        SingleTaskRunner runner = this.builder.setClusterConfigFilePath(options.getClusterConfigFilePath()).setJobId(options.getJobId()).setWorkUnitFilePath(options.getWorkUnitFilePath()).createSingleTaskRunner();
        runner.run();
    }
}

