/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.cluster;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.eventbus.EventBus;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Service;
import com.google.common.util.concurrent.ServiceManager;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigValueFactory;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.cluster.ContainerMetrics;
import org.apache.gobblin.cluster.GobblinClusterManager;
import org.apache.gobblin.cluster.GobblinClusterUtils;
import org.apache.gobblin.cluster.GobblinHelixTaskFactory;
import org.apache.gobblin.cluster.GobblinHelixTaskStateTracker;
import org.apache.gobblin.cluster.GobblinTaskRunnerMetrics;
import org.apache.gobblin.cluster.HelixMessageSubTypes;
import org.apache.gobblin.cluster.HelixTaskFactory;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.instrumented.Instrumented;
import org.apache.gobblin.instrumented.StandardMetricsBridge;
import org.apache.gobblin.metrics.GobblinMetrics;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.runtime.TaskExecutor;
import org.apache.gobblin.runtime.TaskStateTracker;
import org.apache.gobblin.runtime.services.JMXReportingService;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.gobblin.util.FileUtils;
import org.apache.gobblin.util.HadoopUtils;
import org.apache.gobblin.util.JvmUtils;
import org.apache.gobblin.util.PathUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.HelixManagerFactory;
import org.apache.helix.HelixProperty;
import org.apache.helix.InstanceType;
import org.apache.helix.NotificationContext;
import org.apache.helix.messaging.handling.HelixTaskResult;
import org.apache.helix.messaging.handling.MessageHandler;
import org.apache.helix.messaging.handling.MessageHandlerFactory;
import org.apache.helix.model.Message;
import org.apache.helix.participant.statemachine.StateModelFactory;
import org.apache.helix.task.TaskFactory;
import org.apache.helix.task.TaskStateModelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alpha
public class GobblinTaskRunner
implements StandardMetricsBridge {
    private static final Logger logger = LoggerFactory.getLogger(GobblinTaskRunner.class);
    static final Path CLUSTER_CONF_PATH = Paths.get("generated-gobblin-cluster.conf", new String[0]);
    static final String GOBBLIN_TASK_FACTORY_NAME = "GobblinTaskFactory";
    private final String helixInstanceName;
    private HelixManager helixManager;
    private final ServiceManager serviceManager;
    private final TaskStateModelFactory taskStateModelFactory;
    private final Optional<ContainerMetrics> containerMetrics;
    private final String taskRunnerId;
    private volatile boolean stopInProgress = false;
    private volatile boolean isStopped = false;
    protected final EventBus eventBus = new EventBus(GobblinTaskRunner.class.getSimpleName());
    protected final Config config;
    protected final FileSystem fs;
    private final List<Service> services = Lists.newArrayList();
    private final String applicationName;
    private final String applicationId;
    private final org.apache.hadoop.fs.Path appWorkPath;
    private final MetricContext metricContext;
    private final StandardMetricsBridge.StandardMetrics metrics;

    public GobblinTaskRunner(String applicationName, String helixInstanceName, String applicationId, String taskRunnerId, Config config, Optional<org.apache.hadoop.fs.Path> appWorkDirOptional) throws Exception {
        this.helixInstanceName = helixInstanceName;
        this.taskRunnerId = taskRunnerId;
        this.applicationName = applicationName;
        this.applicationId = applicationId;
        Configuration conf = HadoopUtils.newConfiguration();
        this.fs = this.buildFileSystem(config, conf);
        this.appWorkPath = this.initAppWorkDir(config, appWorkDirOptional);
        this.config = this.saveConfigToFile(config);
        this.initHelixManager();
        this.containerMetrics = this.buildContainerMetrics();
        TaskFactoryBuilder builder = new TaskFactoryBuilder(this.config);
        this.taskStateModelFactory = this.createTaskStateModelFactory(builder.build());
        this.metrics = builder.getTaskMetrics();
        this.metricContext = builder.getMetricContext();
        this.services.addAll(this.getServices());
        this.serviceManager = this.services.isEmpty() ? null : new ServiceManager(this.services);
        logger.debug("GobblinTaskRunner: applicationName {}, helixInstanceName {}, applicationId {}, taskRunnerId {}, config {}, appWorkDir {}", new Object[]{applicationName, helixInstanceName, applicationId, taskRunnerId, config, appWorkDirOptional});
    }

    private org.apache.hadoop.fs.Path initAppWorkDir(Config config, Optional<org.apache.hadoop.fs.Path> appWorkDirOptional) {
        return appWorkDirOptional.isPresent() ? (org.apache.hadoop.fs.Path)appWorkDirOptional.get() : GobblinClusterUtils.getAppWorkDirPathFromConfig(config, this.fs, this.applicationName, this.applicationId);
    }

    private void initHelixManager() {
        String zkConnectionString = this.config.getString("gobblin.cluster.zk.connection.string");
        logger.info("Using ZooKeeper connection string: " + zkConnectionString);
        this.helixManager = HelixManagerFactory.getZKHelixManager((String)this.config.getString("gobblin.cluster.helix.cluster.name"), (String)this.helixInstanceName, (InstanceType)InstanceType.PARTICIPANT, (String)zkConnectionString);
    }

    private TaskStateModelFactory createTaskStateModelFactory(TaskFactory factory) {
        HashMap taskFactoryMap = Maps.newHashMap();
        taskFactoryMap.put(GOBBLIN_TASK_FACTORY_NAME, factory);
        TaskStateModelFactory taskStateModelFactory = new TaskStateModelFactory(this.helixManager, (Map)taskFactoryMap);
        this.helixManager.getStateMachineEngine().registerStateModelFactory("Task", (StateModelFactory)taskStateModelFactory);
        return taskStateModelFactory;
    }

    private TaskFactory getInProcessTaskFactory(TaskExecutor taskExecutor) {
        Properties properties = ConfigUtils.configToProperties((Config)this.config);
        URI rootPathUri = PathUtils.getRootPath((org.apache.hadoop.fs.Path)this.appWorkPath).toUri();
        Config stateStoreJobConfig = ConfigUtils.propertiesToConfig((Properties)properties).withValue("state.store.fs.uri", ConfigValueFactory.fromAnyRef((Object)rootPathUri.toString()));
        GobblinHelixTaskStateTracker taskStateTracker = new GobblinHelixTaskStateTracker(properties);
        this.services.add((Service)taskExecutor);
        this.services.add((Service)taskStateTracker);
        this.services.add((Service)new JMXReportingService((Map)ImmutableMap.of((Object)"task.executor", (Object)taskExecutor.getTaskExecutorQueueMetricSet())));
        GobblinHelixTaskFactory taskFactory = new GobblinHelixTaskFactory(this.containerMetrics, taskExecutor, (TaskStateTracker)taskStateTracker, this.fs, this.appWorkPath, stateStoreJobConfig, this.helixManager);
        return taskFactory;
    }

    private Boolean getIsRunTaskInSeparateProcessEnabled() {
        Boolean enabled = false;
        if (this.config.hasPath("gobblin.cluster.enableTaskInSeparateProcess")) {
            enabled = this.config.getBoolean("gobblin.cluster.enableTaskInSeparateProcess");
        }
        return enabled;
    }

    private Config saveConfigToFile(Config config) throws IOException {
        Config newConf = config.withValue("gobblin.cluster.workDir", ConfigValueFactory.fromAnyRef((Object)this.appWorkPath.toString()));
        ConfigUtils configUtils = new ConfigUtils(new FileUtils());
        configUtils.saveConfigToFile(newConf, CLUSTER_CONF_PATH);
        return newConf;
    }

    public void start() {
        logger.info(String.format("Starting %s in container %s", this.helixInstanceName, this.taskRunnerId));
        this.addShutdownHook();
        this.connectHelixManager();
        if (this.containerMetrics.isPresent()) {
            ((ContainerMetrics)((Object)this.containerMetrics.get())).startMetricReportingWithFileSuffix(ConfigUtils.configToState((Config)this.config), this.taskRunnerId);
        }
        if (this.serviceManager != null) {
            this.serviceManager.startAsync();
            this.serviceManager.awaitStopped();
        }
    }

    public synchronized void stop() {
        if (this.isStopped || this.stopInProgress) {
            return;
        }
        this.stopInProgress = true;
        logger.info("Stopping the Gobblin Task runner");
        if (this.containerMetrics.isPresent()) {
            ((ContainerMetrics)((Object)this.containerMetrics.get())).stopMetricsReporting();
        }
        try {
            this.stopServices();
        }
        finally {
            this.taskStateModelFactory.shutdown();
            this.disconnectHelixManager();
        }
        this.isStopped = true;
    }

    private void stopServices() {
        if (this.serviceManager != null) {
            try {
                this.serviceManager.stopAsync().awaitStopped(5L, TimeUnit.MINUTES);
            }
            catch (TimeoutException te) {
                logger.error("Timeout in stopping the service manager", (Throwable)te);
            }
        }
    }

    protected List<Service> getServices() {
        return new ArrayList<Service>();
    }

    @VisibleForTesting
    boolean isStopped() {
        return this.isStopped;
    }

    @VisibleForTesting
    void connectHelixManager() {
        try {
            this.helixManager.connect();
            this.helixManager.getMessagingService().registerMessageHandlerFactory("SHUTDOWN", (MessageHandlerFactory)new ParticipantShutdownMessageHandlerFactory());
            this.helixManager.getMessagingService().registerMessageHandlerFactory(Message.MessageType.USER_DEFINE_MSG.toString(), this.getUserDefinedMessageHandlerFactory());
        }
        catch (Exception e) {
            logger.error("HelixManager failed to connect", (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected MessageHandlerFactory getUserDefinedMessageHandlerFactory() {
        return new ParticipantUserDefinedMessageHandlerFactory();
    }

    @VisibleForTesting
    void disconnectHelixManager() {
        if (this.helixManager.isConnected()) {
            this.helixManager.disconnect();
        }
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                logger.info("Running the shutdown hook");
                GobblinTaskRunner.this.stop();
            }
        });
    }

    private FileSystem buildFileSystem(Config config, Configuration conf) throws IOException {
        return config.hasPath("fs.uri") ? FileSystem.get((URI)URI.create(config.getString("fs.uri")), (Configuration)conf) : FileSystem.get((Configuration)conf);
    }

    private Optional<ContainerMetrics> buildContainerMetrics() {
        Properties properties = ConfigUtils.configToProperties((Config)this.config);
        if (GobblinMetrics.isEnabled((Properties)properties)) {
            return Optional.of((Object)((Object)ContainerMetrics.get(ConfigUtils.configToState((Config)this.config), this.applicationName, this.taskRunnerId)));
        }
        return Optional.absent();
    }

    public StandardMetricsBridge.StandardMetrics getStandardMetrics() {
        return this.metrics;
    }

    @Nonnull
    public MetricContext getMetricContext() {
        return this.metricContext;
    }

    public boolean isInstrumentationEnabled() {
        return GobblinMetrics.isEnabled((Config)this.config);
    }

    private static String getApplicationId() {
        return "1";
    }

    private static String getTaskRunnerId() {
        return UUID.randomUUID().toString();
    }

    public static Options buildOptions() {
        Options options = new Options();
        options.addOption("a", "app_name", true, "Application name");
        options.addOption("i", "helix_instance_name", true, "Helix instance name");
        return options;
    }

    public static void printUsage(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(GobblinClusterManager.class.getSimpleName(), options);
    }

    public static void main(String[] args) throws Exception {
        Options options = GobblinTaskRunner.buildOptions();
        try {
            CommandLine cmd = new DefaultParser().parse(options, args);
            if (!cmd.hasOption("app_name") || !cmd.hasOption("helix_instance_name")) {
                GobblinTaskRunner.printUsage(options);
                System.exit(1);
            }
            logger.info(JvmUtils.getJvmInputArguments());
            String applicationName = cmd.getOptionValue("app_name");
            String helixInstanceName = cmd.getOptionValue("helix_instance_name");
            GobblinTaskRunner gobblinWorkUnitRunner = new GobblinTaskRunner(applicationName, helixInstanceName, GobblinTaskRunner.getApplicationId(), GobblinTaskRunner.getTaskRunnerId(), ConfigFactory.load(), (Optional<org.apache.hadoop.fs.Path>)Optional.absent());
            gobblinWorkUnitRunner.start();
        }
        catch (ParseException pe) {
            GobblinTaskRunner.printUsage(options);
            System.exit(1);
        }
    }

    private static class ParticipantUserDefinedMessageHandlerFactory
    implements MessageHandlerFactory {
        private ParticipantUserDefinedMessageHandlerFactory() {
        }

        public MessageHandler createHandler(Message message, NotificationContext context) {
            return new ParticipantUserDefinedMessageHandler(message, context);
        }

        public String getMessageType() {
            return Message.MessageType.USER_DEFINE_MSG.toString();
        }

        public List<String> getMessageTypes() {
            return Collections.singletonList(this.getMessageType());
        }

        public void reset() {
        }

        private static class ParticipantUserDefinedMessageHandler
        extends MessageHandler {
            public ParticipantUserDefinedMessageHandler(Message message, NotificationContext context) {
                super(message, context);
            }

            public HelixTaskResult handleMessage() throws InterruptedException {
                logger.warn(String.format("No handling setup for %s message of subtype: %s", Message.MessageType.USER_DEFINE_MSG.toString(), this._message.getMsgSubType()));
                HelixTaskResult helixTaskResult = new HelixTaskResult();
                helixTaskResult.setSuccess(true);
                return helixTaskResult;
            }

            public void onError(Exception e, MessageHandler.ErrorCode code, MessageHandler.ErrorType type) {
                logger.error(String.format("Failed to handle message with exception %s, error code %s, error type %s", e, code, type));
            }
        }
    }

    private class ParticipantShutdownMessageHandlerFactory
    implements MessageHandlerFactory {
        private ParticipantShutdownMessageHandlerFactory() {
        }

        public MessageHandler createHandler(Message message, NotificationContext context) {
            return new ParticipantShutdownMessageHandler(message, context);
        }

        public String getMessageType() {
            return "SHUTDOWN";
        }

        public List<String> getMessageTypes() {
            return Collections.singletonList(this.getMessageType());
        }

        public void reset() {
        }

        private class ParticipantShutdownMessageHandler
        extends MessageHandler {
            public ParticipantShutdownMessageHandler(Message message, NotificationContext context) {
                super(message, context);
            }

            public HelixTaskResult handleMessage() throws InterruptedException {
                String messageSubType = this._message.getMsgSubType();
                Preconditions.checkArgument((boolean)messageSubType.equalsIgnoreCase(HelixMessageSubTypes.WORK_UNIT_RUNNER_SHUTDOWN.toString()), (Object)String.format("Unknown %s message subtype: %s", "SHUTDOWN", messageSubType));
                HelixTaskResult result = new HelixTaskResult();
                if (GobblinTaskRunner.this.stopInProgress) {
                    result.setSuccess(true);
                    return result;
                }
                logger.info("Handling message " + HelixMessageSubTypes.WORK_UNIT_RUNNER_SHUTDOWN.toString());
                ScheduledExecutorService shutdownMessageHandlingCompletionWatcher = MoreExecutors.getExitingScheduledExecutorService((ScheduledThreadPoolExecutor)new ScheduledThreadPoolExecutor(1));
                shutdownMessageHandlingCompletionWatcher.scheduleAtFixedRate(new Runnable(){

                    @Override
                    public void run() {
                        HelixManager helixManager = ParticipantShutdownMessageHandler.this._notificationContext.getManager();
                        HelixDataAccessor helixDataAccessor = helixManager.getHelixDataAccessor();
                        HelixProperty helixProperty = helixDataAccessor.getProperty(ParticipantShutdownMessageHandler.this._message.getKey(helixDataAccessor.keyBuilder(), helixManager.getInstanceName()));
                        if (helixProperty == null) {
                            GobblinTaskRunner.this.stop();
                        }
                    }
                }, 0L, 1L, TimeUnit.SECONDS);
                result.setSuccess(true);
                return result;
            }

            public void onError(Exception e, MessageHandler.ErrorCode code, MessageHandler.ErrorType type) {
                logger.error(String.format("Failed to handle message with exception %s, error code %s, error type %s", e, code, type));
            }
        }
    }

    private class TaskFactoryBuilder {
        private final boolean isRunTaskInSeparateProcessEnabled;
        private final TaskFactory taskFactory;
        private final MetricContext metricContext;
        private StandardMetricsBridge.StandardMetrics taskMetrics;

        public TaskFactoryBuilder(Config config) {
            this.isRunTaskInSeparateProcessEnabled = this.getIsRunTaskInSeparateProcessEnabled(config);
            this.metricContext = Instrumented.getMetricContext((State)ConfigUtils.configToState((Config)config), this.getClass());
            if (this.isRunTaskInSeparateProcessEnabled) {
                logger.info("Running a task in a separate process is enabled.");
                this.taskFactory = new HelixTaskFactory((Optional<ContainerMetrics>)GobblinTaskRunner.this.containerMetrics, CLUSTER_CONF_PATH, config);
                this.taskMetrics = new GobblinTaskRunnerMetrics.JvmTaskRunnerMetrics();
            } else {
                Properties properties = ConfigUtils.configToProperties((Config)config);
                TaskExecutor taskExecutor = new TaskExecutor(properties);
                this.taskFactory = GobblinTaskRunner.this.getInProcessTaskFactory(taskExecutor);
                this.taskMetrics = new GobblinTaskRunnerMetrics.InProcessTaskRunnerMetrics(taskExecutor, this.metricContext);
            }
        }

        public TaskFactory build() {
            return this.taskFactory;
        }

        private Boolean getIsRunTaskInSeparateProcessEnabled(Config config) {
            return ConfigUtils.getBoolean((Config)config, (String)"gobblin.cluster.enableTaskInSeparateProcess", (boolean)false);
        }

        public MetricContext getMetricContext() {
            return this.metricContext;
        }

        public StandardMetricsBridge.StandardMetrics getTaskMetrics() {
            return this.taskMetrics;
        }
    }
}

