/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.cluster;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.metrics.GobblinMetrics;
import org.apache.gobblin.runtime.AbstractTaskStateTracker;
import org.apache.gobblin.runtime.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alpha
public class GobblinHelixTaskStateTracker
extends AbstractTaskStateTracker {
    private static final Logger LOGGER = LoggerFactory.getLogger(GobblinHelixTaskStateTracker.class);
    private final Map<String, ScheduledFuture<?>> scheduledReporters = Maps.newHashMap();

    public GobblinHelixTaskStateTracker(Properties properties) {
        super(properties, LOGGER);
    }

    public void registerNewTask(Task task) {
        try {
            this.scheduledReporters.put(task.getTaskId(), this.scheduleTaskMetricsUpdater((Runnable)((Object)new TaskMetricsUpdater(task)), task));
        }
        catch (RejectedExecutionException ree) {
            LOGGER.error(String.format("Scheduling of task state reporter for task %s was rejected", task.getTaskId()));
        }
    }

    public void onTaskRunCompletion(Task task) {
        task.markTaskCompletion();
    }

    public void onTaskCommitCompletion(Task task) {
        if (GobblinMetrics.isEnabled((State)task.getTaskState().getWorkunit())) {
            task.updateRecordMetrics();
            task.updateByteMetrics();
        }
        if (this.scheduledReporters.containsKey(task.getTaskId())) {
            this.scheduledReporters.remove(task.getTaskId()).cancel(false);
        }
        LOGGER.info(String.format("Task %s completed in %dms with state %s", task.getTaskId(), task.getTaskState().getTaskDuration(), task.getTaskState().getWorkingState()));
    }

    class TaskMetricsUpdater
    extends AbstractTaskStateTracker.TaskMetricsUpdater {
        public TaskMetricsUpdater(Task task) {
            super((AbstractTaskStateTracker)GobblinHelixTaskStateTracker.this, task);
        }
    }
}

