/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.cluster;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.gobblin.annotation.Alias;
import org.apache.gobblin.metrics.event.EventName;
import org.apache.gobblin.runtime.EventMetadataUtils;
import org.apache.gobblin.runtime.JobContext;
import org.apache.gobblin.runtime.api.EventMetadataGenerator;

@Alias(value="cluster")
public class ClusterEventMetadataGenerator
implements EventMetadataGenerator {
    public static final String PROCESSED_COUNT_KEY = "processedCount";
    public static final String MESSAGE_KEY = "message";

    public Map<String, String> getMetadata(JobContext jobContext, EventName eventName) {
        List taskStates = jobContext.getJobState().getTaskStates();
        switch (eventName) {
            case JOB_COMPLETE: {
                return ImmutableMap.of((Object)PROCESSED_COUNT_KEY, (Object)Long.toString(EventMetadataUtils.getProcessedCount((List)taskStates)));
            }
            case JOB_FAILED: {
                return ImmutableMap.of((Object)MESSAGE_KEY, (Object)EventMetadataUtils.getTaskFailureExceptions((List)taskStates));
            }
        }
        return ImmutableMap.of();
    }
}

