/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.client;

import com.linkedin.data.ByteString;
import com.linkedin.r2.message.stream.StreamResponse;
import com.linkedin.r2.message.stream.entitystream.EntityStream;
import com.linkedin.r2.message.stream.entitystream.EntityStreams;
import com.linkedin.r2.message.stream.entitystream.ReadHandle;
import com.linkedin.r2.message.stream.entitystream.Reader;
import com.linkedin.r2.message.stream.entitystream.WriteHandle;
import com.linkedin.r2.message.stream.entitystream.Writer;
import com.linkedin.r2.transport.common.bridge.common.TransportCallback;
import com.linkedin.r2.transport.common.bridge.common.TransportResponse;
import com.linkedin.r2.transport.common.bridge.common.TransportResponseImpl;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamExecutionCallback
implements TransportCallback<StreamResponse> {
    private static final Logger LOG = LoggerFactory.getLogger(StreamExecutionCallback.class);
    private final ExecutorService _executor;
    private AtomicReference<TransportCallback<StreamResponse>> _callbackRef;
    private final Queue<Runnable> _taskQueue = new LinkedBlockingQueue<Runnable>();
    private final AtomicInteger _pending = new AtomicInteger(0);
    private final Runnable _eventLoop = new Runnable(){

        @Override
        public void run() {
            try {
                Runnable r = (Runnable)StreamExecutionCallback.this._taskQueue.poll();
                r.run();
            }
            catch (Throwable t) {
                LOG.error("Unexpected throwable in eventLoop.", t);
                Thread.currentThread().getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), t);
            }
            finally {
                if (StreamExecutionCallback.this._pending.decrementAndGet() > 0) {
                    StreamExecutionCallback.this._executor.execute(StreamExecutionCallback.this._eventLoop);
                }
            }
        }
    };

    public StreamExecutionCallback(ExecutorService executor, TransportCallback<StreamResponse> callback) {
        this._executor = executor;
        this._callbackRef = new AtomicReference<TransportCallback<StreamResponse>>(callback);
    }

    private void trySchedule(Runnable r) {
        this._taskQueue.add(r);
        if (this._pending.incrementAndGet() == 1) {
            this._executor.execute(this._eventLoop);
        }
    }

    public void onResponse(TransportResponse<StreamResponse> response) {
        TransportCallback callback = this._callbackRef.getAndSet(null);
        if (callback != null) {
            TransportResponse wrappedResponse;
            if (response.hasError()) {
                wrappedResponse = response;
            } else {
                EventLoopConnector connector = new EventLoopConnector(((StreamResponse)response.getResponse()).getEntityStream());
                StreamResponse newResponse = ((StreamResponse)response.getResponse()).builder().build(EntityStreams.newEntityStream((Writer)connector));
                wrappedResponse = TransportResponseImpl.success((Object)newResponse, (Map)response.getWireAttributes());
            }
            this.trySchedule(() -> callback.onResponse(wrappedResponse));
        } else {
            LOG.warn("Received response {} while _callback is null. Ignored.", response.getResponse());
        }
    }

    private class EventLoopConnector
    implements Reader,
    Writer {
        private WriteHandle _wh;
        private ReadHandle _rh;
        private int _outstanding = 0;
        private volatile boolean _aborted = false;
        private final EntityStream _underlying;

        public EventLoopConnector(EntityStream underlying) {
            this._underlying = underlying;
        }

        public void onInit(ReadHandle rh) {
            this._rh = rh;
        }

        public void onInit(WriteHandle wh) {
            this._wh = wh;
            this._underlying.setReader((Reader)this);
        }

        public void onDataAvailable(ByteString data) {
            if (!this._aborted) {
                StreamExecutionCallback.this.trySchedule(() -> {
                    --this._outstanding;
                    this._wh.write(data);
                    int diff = this._wh.remaining() - this._outstanding;
                    if (diff > 0) {
                        this._rh.request(diff);
                        this._outstanding += diff;
                    }
                });
            }
        }

        public void onDone() {
            StreamExecutionCallback.this.trySchedule(() -> ((WriteHandle)this._wh).done());
        }

        public void onError(Throwable e) {
            StreamExecutionCallback.this.trySchedule(() -> this._wh.error(e));
        }

        public void onWritePossible() {
            StreamExecutionCallback.this.trySchedule(() -> {
                this._outstanding = this._wh.remaining();
                this._rh.request(this._outstanding);
            });
        }

        public void onAbort(Throwable e) {
            this._aborted = true;
            this._rh.cancel();
        }
    }
}

