/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.client;

import com.linkedin.r2.message.Request;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.stream.StreamRequest;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.util.AsciiString;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Map;

class NettyRequestAdapter {
    private static final HashSet<String> HEADER_BLACKLIST = new HashSet();

    private NettyRequestAdapter() {
    }

    static HttpRequest toNettyRequest(RestRequest request) throws Exception {
        HttpMethod nettyMethod = HttpMethod.valueOf((String)request.getMethod());
        URL url = new URL(request.getURI().toString());
        String path = url.getFile();
        if (path.isEmpty()) {
            path = "/";
        }
        ByteBuf content = Unpooled.wrappedBuffer((ByteBuffer)request.getEntity().asByteBuffer());
        DefaultFullHttpRequest nettyRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, nettyMethod, path, content);
        nettyRequest.headers().set("Content-Length", (Object)request.getEntity().length());
        for (Map.Entry entry : request.getHeaders().entrySet()) {
            nettyRequest.headers().set((String)entry.getKey(), entry.getValue());
        }
        nettyRequest.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)url.getAuthority());
        nettyRequest.headers().set("Cookie", (Iterable)request.getCookies());
        return nettyRequest;
    }

    static HttpRequest toNettyRequest(StreamRequest request) throws Exception {
        HttpMethod nettyMethod = HttpMethod.valueOf((String)request.getMethod());
        URL url = new URL(request.getURI().toString());
        String path = url.getFile();
        if (path.isEmpty()) {
            path = "/";
        }
        DefaultHttpRequest nettyRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, nettyMethod, path);
        nettyRequest.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        for (Map.Entry entry : request.getHeaders().entrySet()) {
            if (((String)entry.getKey()).equalsIgnoreCase(HttpHeaderNames.CONTENT_LENGTH.toString())) continue;
            nettyRequest.headers().set((String)entry.getKey(), entry.getValue());
        }
        nettyRequest.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)url.getAuthority());
        nettyRequest.headers().set("Cookie", (Iterable)request.getCookies());
        return nettyRequest;
    }

    static <R extends Request> Http2Headers toHttp2Headers(R request) throws Exception {
        URI uri = request.getURI();
        URL url = new URL(uri.toString());
        String method = request.getMethod();
        String authority = url.getAuthority();
        String path = url.getFile();
        String scheme = uri.getScheme();
        path = path.isEmpty() ? "/" : path;
        Http2Headers headers = new DefaultHttp2Headers().method((CharSequence)method).authority((CharSequence)authority).path((CharSequence)path).scheme((CharSequence)scheme);
        for (Map.Entry entry : request.getHeaders().entrySet()) {
            if (HEADER_BLACKLIST.contains(((String)entry.getKey()).toLowerCase())) continue;
            String name = ((String)entry.getKey()).toLowerCase();
            String value = (String)entry.getValue();
            headers.set((Object)name, (Object)value);
        }
        headers.set((Object)HttpHeaderNames.COOKIE, (Iterable)request.getCookies());
        return headers;
    }

    static {
        HEADER_BLACKLIST.add(HttpHeaderNames.CONNECTION.toString());
        AsciiString keepAlive = HttpHeaderNames.KEEP_ALIVE;
        HEADER_BLACKLIST.add(keepAlive.toString());
        AsciiString proxyConnection = HttpHeaderNames.PROXY_CONNECTION;
        HEADER_BLACKLIST.add(proxyConnection.toString());
        HEADER_BLACKLIST.add(HttpHeaderNames.TRANSFER_ENCODING.toString());
        HEADER_BLACKLIST.add(HttpHeaderNames.HOST.toString());
        HEADER_BLACKLIST.add(HttpHeaderNames.UPGRADE.toString());
        HEADER_BLACKLIST.add(HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text().toString());
        HEADER_BLACKLIST.add(HttpConversionUtil.ExtensionHeaderNames.SCHEME.text().toString());
        HEADER_BLACKLIST.add(HttpConversionUtil.ExtensionHeaderNames.PATH.text().toString());
    }
}

