/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.client;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.callback.Callbacks;
import com.linkedin.common.util.None;
import com.linkedin.r2.transport.http.client.AsyncPool;
import com.linkedin.r2.transport.http.client.ChannelPoolFactory;
import com.linkedin.r2.transport.http.client.PoolStats;
import com.linkedin.r2.transport.http.client.PoolStatsProvider;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ChannelPoolManager
implements PoolStatsProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ChannelPoolManager.class);
    public static final String BASE_NAME = "ChannelPools";
    private final Object _mutex = new Object();
    private final ConcurrentMap<SocketAddress, AsyncPool<Channel>> _pool = new ConcurrentHashMap<SocketAddress, AsyncPool<Channel>>(256, 0.75f, 1);
    private State _state = State.RUNNING;
    private final ChannelPoolFactory _channelPoolFactory;
    private final String _name;

    public ChannelPoolManager(ChannelPoolFactory channelPoolFactory) {
        this(channelPoolFactory, "noNameSpecifiedClientChannelPools");
    }

    public ChannelPoolManager(ChannelPoolFactory channelPoolFactory, String name) {
        this._channelPoolFactory = channelPoolFactory;
        this._name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(final Callback<None> callback) {
        Collection pools;
        State state;
        Object object = this._mutex;
        synchronized (object) {
            state = this._state;
            pools = this._pool.values();
            if (state == State.RUNNING) {
                this._state = State.SHUTTING_DOWN;
            }
        }
        if (state != State.RUNNING) {
            callback.onError((Throwable)new IllegalStateException("ChannelPoolManager is " + (Object)((Object)state)));
            return;
        }
        LOG.info("Shutting down {} connection pools", (Object)pools.size());
        Callback poolCallback = Callbacks.countDown((Callback)new Callback<None>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSuccess(None none) {
                Object object = ChannelPoolManager.this._mutex;
                synchronized (object) {
                    ChannelPoolManager.this._state = State.SHUTDOWN;
                }
                LOG.info("All connection pools shutdown");
                callback.onSuccess((Object)None.none());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onError(Throwable e) {
                Object object = ChannelPoolManager.this._mutex;
                synchronized (object) {
                    ChannelPoolManager.this._state = State.SHUTDOWN;
                }
                LOG.error("Error shutting down connection pools", e);
                callback.onError(e);
            }
        }, (int)pools.size());
        for (AsyncPool pool : pools) {
            pool.shutdown(poolCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Callback<Channel>> cancelWaiters() {
        Collection pools;
        ArrayList<Callback<Channel>> cancelled = new ArrayList<Callback<Channel>>();
        Iterator iterator = this._mutex;
        synchronized (iterator) {
            pools = this._pool.values();
        }
        for (AsyncPool pool : pools) {
            cancelled.addAll(pool.cancelWaiters());
        }
        return cancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncPool<Channel> getPoolForAddress(SocketAddress address) throws IllegalStateException {
        AsyncPool pool = (AsyncPool)this._pool.get(address);
        if (pool != null) {
            return pool;
        }
        Object object = this._mutex;
        synchronized (object) {
            if (this._state != State.RUNNING) {
                throw new IllegalStateException("ChannelPoolManager is shutting down");
            }
            pool = (AsyncPool)this._pool.get(address);
            if (pool == null) {
                pool = this._channelPoolFactory.getPool(address);
                pool.start();
                this._pool.put(address, pool);
            }
        }
        return pool;
    }

    public Map<String, PoolStats> getPoolStats() {
        HashMap<String, PoolStats> stats = new HashMap<String, PoolStats>();
        for (AsyncPool pool : this._pool.values()) {
            stats.put(pool.getName(), pool.getStats());
        }
        return stats;
    }

    public String getName() {
        return this._name;
    }

    private static enum State {
        RUNNING,
        SHUTTING_DOWN,
        SHUTDOWN;

    }
}

