/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.gobblin.async.AsyncRequestBuilder;
import org.apache.gobblin.broker.gobblin_scopes.GobblinScopeTypes;
import org.apache.gobblin.broker.iface.SharedResourcesBroker;
import org.apache.gobblin.config.ConfigBuilder;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.http.HttpClient;
import org.apache.gobblin.http.ResponseHandler;
import org.apache.gobblin.instrumented.Instrumented;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.gobblin.writer.AsyncHttpWriter;
import org.apache.gobblin.writer.AsyncWriterManager;
import org.apache.gobblin.writer.DataWriter;
import org.apache.gobblin.writer.Destination;
import org.apache.gobblin.writer.FluentDataWriterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AsyncHttpWriterBuilder<D, RQ, RP>
extends FluentDataWriterBuilder<Void, D, AsyncHttpWriterBuilder<D, RQ, RP>> {
    private static final Logger log = LoggerFactory.getLogger(AsyncHttpWriterBuilder.class);
    public static final String CONF_PREFIX = "gobblin.writer.http.";
    private static final Config FALLBACK = ConfigFactory.parseMap((Map)ImmutableMap.builder().put((Object)"errorCodeWhitelist", (Object)"").build());
    MetricContext metricContext;
    protected WorkUnitState state;
    protected HttpClient<RQ, RP> client = null;
    protected AsyncRequestBuilder<D, RQ> asyncRequestBuilder = null;
    protected ResponseHandler<RQ, RP> responseHandler = null;
    protected int queueCapacity = 10000;
    protected int maxAttempts = 3;
    protected SharedResourcesBroker<GobblinScopeTypes> broker = null;

    public AsyncHttpWriterBuilder<D, RQ, RP> writeTo(Destination destination) {
        super.writeTo(destination);
        return this.fromState(destination.getProperties());
    }

    AsyncHttpWriterBuilder<D, RQ, RP> fromState(State state) {
        if (!(state instanceof WorkUnitState)) {
            throw new IllegalStateException(String.format("AsyncHttpWriterBuilder requires a %s on construction.", WorkUnitState.class.getSimpleName()));
        }
        this.state = (WorkUnitState)state;
        this.metricContext = Instrumented.getMetricContext((State)this.state, AsyncHttpWriter.class);
        this.broker = this.state.getTaskBroker();
        Config config = ConfigBuilder.create().loadProps(state.getProperties(), CONF_PREFIX).build();
        config = config.withFallback((ConfigMergeable)FALLBACK);
        return this.fromConfig(config);
    }

    public abstract AsyncHttpWriterBuilder<D, RQ, RP> fromConfig(Config var1);

    protected void validate() {
        Preconditions.checkNotNull((Object)this.getState(), (Object)("State is required for " + ((Object)((Object)this)).getClass().getSimpleName()));
        Preconditions.checkNotNull(this.getClient(), (Object)("Client is required for " + ((Object)((Object)this)).getClass().getSimpleName()));
        Preconditions.checkNotNull(this.getAsyncRequestBuilder(), (Object)("AsyncWriteRequestBuilder is required for " + ((Object)((Object)this)).getClass().getSimpleName()));
        Preconditions.checkNotNull(this.getResponseHandler(), (Object)("ResponseHandler is required for " + ((Object)((Object)this)).getClass().getSimpleName()));
    }

    public DataWriter<D> build() throws IOException {
        this.validate();
        return AsyncWriterManager.builder().config(ConfigUtils.propertiesToConfig((Properties)this.getState().getProperties())).asyncDataWriter(new AsyncHttpWriter(this)).retriesEnabled(false).commitTimeoutMillis(10000L).failureAllowanceRatio(0.0).build();
    }

    public MetricContext getMetricContext() {
        return this.metricContext;
    }

    public WorkUnitState getState() {
        return this.state;
    }

    public HttpClient<RQ, RP> getClient() {
        return this.client;
    }

    public AsyncRequestBuilder<D, RQ> getAsyncRequestBuilder() {
        return this.asyncRequestBuilder;
    }

    public ResponseHandler<RQ, RP> getResponseHandler() {
        return this.responseHandler;
    }

    public int getQueueCapacity() {
        return this.queueCapacity;
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public SharedResourcesBroker<GobblinScopeTypes> getBroker() {
        return this.broker;
    }
}

