/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.http;

import com.google.common.collect.ImmutableMap;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.async.Callback;
import org.apache.gobblin.broker.gobblin_scopes.GobblinScopeTypes;
import org.apache.gobblin.broker.iface.SharedResourcesBroker;
import org.apache.gobblin.http.ApacheHttpClient;
import org.apache.gobblin.http.ThrottledHttpClient;
import org.apache.gobblin.utils.HttpUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheHttpAsyncClient
extends ThrottledHttpClient<HttpUriRequest, HttpResponse> {
    private static final Logger log = LoggerFactory.getLogger(ApacheHttpAsyncClient.class);
    private static final Logger LOG = LoggerFactory.getLogger(ApacheHttpClient.class);
    public static final String HTTP_CONN_MANAGER = "connMgrType";
    public static final String POOLING_CONN_MANAGER_MAX_TOTAL_CONN = "connMgr.pooling.maxTotalConn";
    public static final String POOLING_CONN_MANAGER_MAX_PER_CONN = "connMgr.pooling.maxPerConn";
    public static final String REQUEST_TIME_OUT_MS_KEY = "reqTimeout";
    public static final String CONNECTION_TIME_OUT_MS_KEY = "connTimeout";
    private static final Config FALLBACK = ConfigFactory.parseMap((Map)ImmutableMap.builder().put((Object)"reqTimeout", (Object)TimeUnit.SECONDS.toMillis(10L)).put((Object)"connTimeout", (Object)TimeUnit.SECONDS.toMillis(10L)).put((Object)"connMgrType", (Object)ApacheHttpClient.ConnManager.POOLING.name()).put((Object)"connMgr.pooling.maxTotalConn", (Object)20).put((Object)"connMgr.pooling.maxPerConn", (Object)2).build());
    private final CloseableHttpAsyncClient client;

    public ApacheHttpAsyncClient(HttpAsyncClientBuilder builder, Config config, SharedResourcesBroker<GobblinScopeTypes> broker) {
        super(broker, HttpUtils.createApacheHttpClientLimiterKey(config));
        config = config.withFallback((ConfigMergeable)FALLBACK);
        RequestConfig requestConfig = RequestConfig.copy((RequestConfig)RequestConfig.DEFAULT).setSocketTimeout(config.getInt(REQUEST_TIME_OUT_MS_KEY)).setConnectTimeout(config.getInt(CONNECTION_TIME_OUT_MS_KEY)).setConnectionRequestTimeout(config.getInt(CONNECTION_TIME_OUT_MS_KEY)).build();
        try {
            builder.disableCookieManagement().useSystemProperties().setDefaultRequestConfig(requestConfig);
            builder.setConnectionManager(this.getNHttpConnManager(config));
            this.client = builder.build();
            this.client.start();
        }
        catch (IOException e) {
            throw new RuntimeException("ApacheHttpAsyncClient cannot be initialized");
        }
    }

    private NHttpClientConnectionManager getNHttpConnManager(Config config) throws IOException {
        PoolingNHttpClientConnectionManager httpConnManager;
        String connMgrStr = config.getString(HTTP_CONN_MANAGER);
        switch (ApacheHttpClient.ConnManager.valueOf(connMgrStr.toUpperCase())) {
            case POOLING: {
                DefaultConnectingIOReactor ioReactor = new DefaultConnectingIOReactor();
                PoolingNHttpClientConnectionManager poolingConnMgr = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)ioReactor);
                poolingConnMgr.setMaxTotal(config.getInt(POOLING_CONN_MANAGER_MAX_TOTAL_CONN));
                poolingConnMgr.setDefaultMaxPerRoute(config.getInt(POOLING_CONN_MANAGER_MAX_PER_CONN));
                httpConnManager = poolingConnMgr;
                break;
            }
            default: {
                throw new IllegalArgumentException(connMgrStr + " is not supported");
            }
        }
        LOG.info("Using " + httpConnManager.getClass().getSimpleName());
        return httpConnManager;
    }

    @Override
    public HttpResponse sendRequestImpl(HttpUriRequest request) throws IOException {
        SyncHttpResponseCallback callback = new SyncHttpResponseCallback(request);
        this.client.execute(request, (FutureCallback)callback);
        try {
            callback.await();
            if (callback.getException() != null) {
                throw new IOException(callback.getException());
            }
            return callback.getResponse();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void sendAsyncRequestImpl(HttpUriRequest request, final Callback<HttpResponse> callback) throws IOException {
        this.client.execute(request, (FutureCallback)new FutureCallback<HttpResponse>(){

            public void completed(HttpResponse result) {
                callback.onSuccess((Object)result);
            }

            public void failed(Exception ex) {
                callback.onFailure((Throwable)ex);
            }

            public void cancelled() {
                throw new UnsupportedOperationException();
            }
        });
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    private static class SyncHttpResponseCallback
    implements FutureCallback<HttpResponse> {
        private HttpUriRequest request = null;
        private HttpResponse response = null;
        private Exception exception = null;
        private final CountDownLatch latch = new CountDownLatch(1);

        public SyncHttpResponseCallback(HttpUriRequest request) {
            this.request = request;
        }

        public void completed(HttpResponse result) {
            log.info("Sync apache version request: {}, statusCode: {}", (Object)this.request, (Object)result.getStatusLine().getStatusCode());
            this.response = result;
            this.latch.countDown();
        }

        public void failed(Exception ex) {
            this.exception = ex;
            this.latch.countDown();
        }

        public void cancelled() {
            throw new UnsupportedOperationException("Should not be cancelled");
        }

        public void await() throws InterruptedException {
            this.latch.await();
        }

        public HttpUriRequest getRequest() {
            return this.request;
        }

        public HttpResponse getResponse() {
            return this.response;
        }

        public Exception getException() {
            return this.exception;
        }

        public CountDownLatch getLatch() {
            return this.latch;
        }
    }
}

