/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.converter;

import com.google.common.collect.ImmutableMap;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.avro.generic.GenericRecord;
import org.apache.gobblin.async.AsyncRequest;
import org.apache.gobblin.async.AsyncRequestBuilder;
import org.apache.gobblin.async.BufferedRecord;
import org.apache.gobblin.async.Callback;
import org.apache.gobblin.broker.gobblin_scopes.GobblinScopeTypes;
import org.apache.gobblin.broker.iface.SharedResourcesBroker;
import org.apache.gobblin.config.ConfigBuilder;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.Converter;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.converter.SchemaConversionException;
import org.apache.gobblin.converter.SingleRecordIterable;
import org.apache.gobblin.http.HttpClient;
import org.apache.gobblin.http.HttpOperation;
import org.apache.gobblin.http.ResponseHandler;
import org.apache.gobblin.http.ResponseStatus;
import org.apache.gobblin.net.Request;
import org.apache.gobblin.writer.WriteCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpJoinConverter<SI, SO, DI, DO, RQ, RP>
extends Converter<SI, SO, DI, DO> {
    private static final Logger log = LoggerFactory.getLogger(HttpJoinConverter.class);
    public static final String CONF_PREFIX = "gobblin.converter.http.";
    public static final Config DEFAULT_FALLBACK = ConfigFactory.parseMap((Map)ImmutableMap.builder().put((Object)"contentType", (Object)"application/json").put((Object)"verb", (Object)"GET").build());
    protected HttpClient<RQ, RP> httpClient = null;
    protected ResponseHandler<RQ, RP> responseHandler = null;
    protected AsyncRequestBuilder<GenericRecord, RQ> requestBuilder = null;

    public HttpJoinConverter init(WorkUnitState workUnitState) {
        super.init(workUnitState);
        Config config = ConfigBuilder.create().loadProps(workUnitState.getProperties(), CONF_PREFIX).build();
        config = config.withFallback((ConfigMergeable)DEFAULT_FALLBACK);
        this.httpClient = this.createHttpClient(config, (SharedResourcesBroker<GobblinScopeTypes>)workUnitState.getTaskBroker());
        this.responseHandler = this.createResponseHandler(config);
        this.requestBuilder = this.createRequestBuilder(config);
        return this;
    }

    public final SO convertSchema(SI inputSchema, WorkUnitState workUnitState) throws SchemaConversionException {
        return this.convertSchemaImpl(inputSchema, workUnitState);
    }

    protected abstract HttpClient<RQ, RP> createHttpClient(Config var1, SharedResourcesBroker<GobblinScopeTypes> var2);

    protected abstract ResponseHandler<RQ, RP> createResponseHandler(Config var1);

    protected abstract AsyncRequestBuilder<GenericRecord, RQ> createRequestBuilder(Config var1);

    protected abstract HttpOperation generateHttpOperation(DI var1, State var2);

    protected abstract SO convertSchemaImpl(SI var1, WorkUnitState var2) throws SchemaConversionException;

    protected abstract DO convertRecordImpl(SO var1, DI var2, RQ var3, ResponseStatus var4) throws DataConversionException;

    public final Iterable<DO> convertRecord(SO outputSchema, DI inputRecord, WorkUnitState workUnitState) throws DataConversionException {
        HttpOperation operation = this.generateHttpOperation(inputRecord, (State)workUnitState);
        BufferedRecord bufferedRecord = new BufferedRecord((Object)operation, (Callback)WriteCallback.EMPTY);
        LinkedBlockingDeque<BufferedRecord> buffer = new LinkedBlockingDeque<BufferedRecord>();
        buffer.add(bufferedRecord);
        AsyncRequest request = this.requestBuilder.buildRequest(buffer);
        Object rawRequest = request.getRawRequest();
        try {
            RP response = this.httpClient.sendRequest(rawRequest);
            ResponseStatus status = this.responseHandler.handleResponse((Request<RQ>)request, response);
            switch (status.getType()) {
                case OK: 
                case CLIENT_ERROR: {
                    log.debug("{} send with status type {}", rawRequest, (Object)status.getType());
                    DO output = this.convertRecordImpl(outputSchema, inputRecord, rawRequest, status);
                    return new SingleRecordIterable(output);
                }
                case SERVER_ERROR: {
                    throw new DataConversionException(rawRequest + " send failed due to server error");
                }
            }
            throw new DataConversionException(rawRequest + " Should not reach here");
        }
        catch (IOException e) {
            throw new DataConversionException((Throwable)e);
        }
    }

    public void close() throws IOException {
        this.httpClient.close();
    }
}

