/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.converter;

import com.google.common.collect.ImmutableMap;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.avro.generic.GenericRecord;
import org.apache.gobblin.async.AsyncRequest;
import org.apache.gobblin.async.AsyncRequestBuilder;
import org.apache.gobblin.async.BufferedRecord;
import org.apache.gobblin.async.Callback;
import org.apache.gobblin.broker.gobblin_scopes.GobblinScopeTypes;
import org.apache.gobblin.broker.iface.SharedResourcesBroker;
import org.apache.gobblin.config.ConfigBuilder;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.AsyncConverter1to1;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.converter.SchemaConversionException;
import org.apache.gobblin.http.HttpClient;
import org.apache.gobblin.http.HttpOperation;
import org.apache.gobblin.http.ResponseHandler;
import org.apache.gobblin.http.ResponseStatus;
import org.apache.gobblin.net.Request;
import org.apache.gobblin.writer.WriteCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AsyncHttpJoinConverter<SI, SO, DI, DO, RQ, RP>
extends AsyncConverter1to1<SI, SO, DI, DO> {
    private static final Logger log = LoggerFactory.getLogger(AsyncHttpJoinConverter.class);
    public static final String CONF_PREFIX = "gobblin.converter.http.";
    public static final Config DEFAULT_FALLBACK = ConfigFactory.parseMap((Map)ImmutableMap.builder().put((Object)"contentType", (Object)"application/json").put((Object)"verb", (Object)"GET").build());
    protected HttpClient<RQ, RP> httpClient = null;
    protected ResponseHandler<RQ, RP> responseHandler = null;
    protected AsyncRequestBuilder<GenericRecord, RQ> requestBuilder = null;
    protected boolean skipFailedRecord;

    public AsyncHttpJoinConverter init(WorkUnitState workUnitState) {
        super.init(workUnitState);
        Config config = ConfigBuilder.create().loadProps(workUnitState.getProperties(), CONF_PREFIX).build();
        config = config.withFallback((ConfigMergeable)DEFAULT_FALLBACK);
        this.skipFailedRecord = workUnitState.getPropAsBoolean("converter.skipFailedRecord", false);
        this.httpClient = this.createHttpClient(config, (SharedResourcesBroker<GobblinScopeTypes>)workUnitState.getTaskBroker());
        this.responseHandler = this.createResponseHandler(config);
        this.requestBuilder = this.createRequestBuilder(config);
        return this;
    }

    public final SO convertSchema(SI inputSchema, WorkUnitState workUnitState) throws SchemaConversionException {
        return this.convertSchemaImpl(inputSchema, workUnitState);
    }

    protected abstract HttpClient<RQ, RP> createHttpClient(Config var1, SharedResourcesBroker<GobblinScopeTypes> var2);

    protected abstract ResponseHandler<RQ, RP> createResponseHandler(Config var1);

    protected abstract AsyncRequestBuilder<GenericRecord, RQ> createRequestBuilder(Config var1);

    protected abstract HttpOperation generateHttpOperation(DI var1, State var2);

    protected abstract SO convertSchemaImpl(SI var1, WorkUnitState var2) throws SchemaConversionException;

    protected abstract DO convertRecordImpl(SO var1, DI var2, RQ var3, ResponseStatus var4) throws DataConversionException;

    public final CompletableFuture<DO> convertRecordAsync(SO outputSchema, DI inputRecord, WorkUnitState workUnitState) throws DataConversionException {
        HttpOperation operation = this.generateHttpOperation(inputRecord, (State)workUnitState);
        BufferedRecord bufferedRecord = new BufferedRecord((Object)operation, (Callback)WriteCallback.EMPTY);
        LinkedBlockingDeque<BufferedRecord> buffer = new LinkedBlockingDeque<BufferedRecord>();
        buffer.add(bufferedRecord);
        AsyncRequest request = this.requestBuilder.buildRequest(buffer);
        Object rawRequest = request.getRawRequest();
        AsyncHttpJoinConverterContext context = new AsyncHttpJoinConverterContext(this, outputSchema, inputRecord, request);
        try {
            this.httpClient.sendAsyncRequest(rawRequest, context.getCallback());
        }
        catch (IOException e) {
            throw new DataConversionException((Throwable)e);
        }
        return context.future;
    }

    public void close() throws IOException {
        this.httpClient.close();
    }

    private class AsyncHttpJoinConverterContext<SO, DI, DO, RP, RQ> {
        private final CompletableFuture<DO> future = new CompletableFuture();
        private final AsyncHttpJoinConverter<SI, SO, DI, DO, RQ, RP> converter;
        private final Callback<RP> callback;

        public AsyncHttpJoinConverterContext(AsyncHttpJoinConverter converter, final SO outputSchema, final DI input, final Request<RQ> request) {
            this.converter = converter;
            this.callback = new Callback<RP>(){

                public void onSuccess(RP result) {
                    try {
                        ResponseStatus status = ((AsyncHttpJoinConverterContext)AsyncHttpJoinConverterContext.this).converter.responseHandler.handleResponse(request, result);
                        switch (status.getType()) {
                            case OK: {
                                AsyncHttpJoinConverterContext.this.onSuccess(request.getRawRequest(), status, outputSchema, input);
                                break;
                            }
                            case CLIENT_ERROR: {
                                log.error("Http converter client error with request {}", request.getRawRequest());
                                AsyncHttpJoinConverterContext.this.onSuccess(request.getRawRequest(), status, outputSchema, input);
                                break;
                            }
                            case SERVER_ERROR: {
                                log.error("Http converter server error with request {}", request.getRawRequest());
                                throw new DataConversionException(request.getRawRequest() + " send failed due to server error");
                            }
                            default: {
                                throw new DataConversionException(request.getRawRequest() + " Should not reach here");
                            }
                        }
                    }
                    catch (Exception e) {
                        log.error("Http converter exception {} with request {}", (Object)e.toString(), request.getRawRequest());
                        AsyncHttpJoinConverterContext.this.future.completeExceptionally(e);
                    }
                }

                @SuppressWarnings(value={"NP_NONNULL_PARAM_VIOLATION"}, justification="CompletableFuture will replace null value with NIL")
                public void onFailure(Throwable throwable) {
                    log.error("Http converter on failure with request {}", request.getRawRequest());
                    if (AsyncHttpJoinConverter.this.skipFailedRecord) {
                        AsyncHttpJoinConverterContext.this.future.complete(null);
                    } else {
                        AsyncHttpJoinConverterContext.this.future.completeExceptionally(throwable);
                    }
                }
            };
        }

        private void onSuccess(RQ rawRequest, ResponseStatus status, SO outputSchema, DI input) throws DataConversionException {
            log.debug("{} send with status type {}", rawRequest, (Object)status.getType());
            DO output = this.converter.convertRecordImpl(outputSchema, input, rawRequest, status);
            this.future.complete(output);
        }

        public Callback<RP> getCallback() {
            return this.callback;
        }
    }
}

