/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor.extract.kafka;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.source.extractor.Extractor;
import org.apache.gobblin.source.extractor.extract.kafka.KafkaExtractor;
import org.apache.gobblin.source.extractor.extract.kafka.KafkaSource;
import org.apache.gobblin.util.ClassAliasResolver;
import org.apache.gobblin.util.reflection.GobblinConstructorUtils;

public class UniversalKafkaSource<S, D>
extends KafkaSource<S, D> {
    public static final String EXTRACTOR_TYPE = "gobblin.source.kafka.extractorType";

    public Extractor<S, D> getExtractor(WorkUnitState state) throws IOException {
        Preconditions.checkArgument((boolean)state.contains(EXTRACTOR_TYPE), (Object)"Missing key gobblin.source.kafka.extractorType");
        try {
            ClassAliasResolver aliasResolver = new ClassAliasResolver(KafkaExtractor.class);
            Class klazz = aliasResolver.resolveClass(state.getProp(EXTRACTOR_TYPE));
            return (Extractor)GobblinConstructorUtils.invokeLongestConstructor((Class)klazz, (Object[])new Object[]{state});
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

