/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics.kafka;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.gobblin.metrics.kafka.KafkaSchemaRegistry;
import org.apache.gobblin.metrics.kafka.SchemaRegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KafkaSchemaRegistry<K, S> {
    private static final Logger log = LoggerFactory.getLogger(KafkaSchemaRegistry.class);
    public static final String KAFKA_SCHEMA_REGISTRY_CLASS = "kafka.schema.registry.class";
    public static final String KAFKA_SCHEMA_REGISTRY_URL = "kafka.schema.registry.url";
    public static final int GET_SCHEMA_BY_ID_MAX_TIRES = 3;
    public static final int GET_SCHEMA_BY_ID_MIN_INTERVAL_SECONDS = 1;
    public static final String KAFKA_SCHEMA_REGISTRY_MAX_CACHE_SIZE = "kafka.schema.registry.max.cache.size";
    public static final String DEFAULT_KAFKA_SCHEMA_REGISTRY_MAX_CACHE_SIZE = "1000";
    public static final String KAFKA_SCHEMA_REGISTRY_CACHE_EXPIRE_AFTER_WRITE_MIN = "kafka.schema.registry.cache.expire.after.write.min";
    public static final String DEFAULT_KAFKA_SCHEMA_REGISTRY_CACHE_EXPIRE_AFTER_WRITE_MIN = "10";
    protected final Properties props;
    protected final LoadingCache<K, S> cachedSchemasByKeys;

    protected KafkaSchemaRegistry(Properties props) {
        this.props = props;
        int maxCacheSize = Integer.parseInt(props.getProperty(KAFKA_SCHEMA_REGISTRY_MAX_CACHE_SIZE, DEFAULT_KAFKA_SCHEMA_REGISTRY_MAX_CACHE_SIZE));
        int expireAfterWriteMin = Integer.parseInt(props.getProperty(KAFKA_SCHEMA_REGISTRY_CACHE_EXPIRE_AFTER_WRITE_MIN, DEFAULT_KAFKA_SCHEMA_REGISTRY_CACHE_EXPIRE_AFTER_WRITE_MIN));
        this.cachedSchemasByKeys = CacheBuilder.newBuilder().maximumSize((long)maxCacheSize).expireAfterWrite((long)expireAfterWriteMin, TimeUnit.MINUTES).build((CacheLoader)new KafkaSchemaCacheLoader());
    }

    public static <K, S> KafkaSchemaRegistry<K, S> get(Properties props) {
        Preconditions.checkArgument((boolean)props.containsKey(KAFKA_SCHEMA_REGISTRY_CLASS), (Object)"Missing required property kafka.schema.registry.class");
        try {
            Class<?> clazz = Class.forName(props.getProperty(KAFKA_SCHEMA_REGISTRY_CLASS));
            return (KafkaSchemaRegistry)ConstructorUtils.invokeConstructor(clazz, (Object[])new Object[]{props});
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            log.error("Failed to instantiate " + KafkaSchemaRegistry.class, (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    public S getSchemaByKey(K key) throws SchemaRegistryException {
        try {
            return (S)this.cachedSchemasByKeys.get(key);
        }
        catch (ExecutionException e) {
            throw new SchemaRegistryException(String.format("Schema with key %s cannot be retrieved", key), e);
        }
    }

    protected abstract S fetchSchemaByKey(K var1) throws SchemaRegistryException;

    public abstract S getLatestSchemaByTopic(String var1) throws SchemaRegistryException;

    public abstract K register(S var1) throws SchemaRegistryException;

    public abstract K register(S var1, String var2) throws SchemaRegistryException;

    private class KafkaSchemaCacheLoader
    extends CacheLoader<K, S> {
        private final ConcurrentMap<K, org.apache.gobblin.metrics.kafka.KafkaSchemaRegistry$KafkaSchemaCacheLoader.FailedFetchHistory> failedFetchHistories = Maps.newConcurrentMap();

        private KafkaSchemaCacheLoader() {
        }

        public S load(K key) throws Exception {
            if (this.shouldFetchFromSchemaRegistry(key)) {
                try {
                    return KafkaSchemaRegistry.this.fetchSchemaByKey(key);
                }
                catch (SchemaRegistryException e) {
                    this.addFetchToFailureHistory(key);
                    throw e;
                }
            }
            throw new SchemaRegistryException(String.format("Schema with key %s cannot be retrieved", key));
        }

        private void addFetchToFailureHistory(K key) {
            this.failedFetchHistories.putIfAbsent(key, (org.apache.gobblin.metrics.kafka.KafkaSchemaRegistry$KafkaSchemaCacheLoader.FailedFetchHistory)new FailedFetchHistory(System.nanoTime()));
            ((FailedFetchHistory)this.failedFetchHistories.get(key)).incrementNumOfAttempts();
            ((FailedFetchHistory)this.failedFetchHistories.get(key)).setPreviousAttemptTime(System.nanoTime());
        }

        private boolean shouldFetchFromSchemaRegistry(K key) {
            if (!this.failedFetchHistories.containsKey(key)) {
                return true;
            }
            FailedFetchHistory failedFetchHistory = (FailedFetchHistory)this.failedFetchHistories.get(key);
            boolean maxTriesNotExceeded = failedFetchHistory.getNumOfAttempts() < 3;
            boolean minRetryIntervalSatisfied = System.nanoTime() - failedFetchHistory.getPreviousAttemptTime() >= TimeUnit.SECONDS.toNanos(1L);
            return maxTriesNotExceeded && minRetryIntervalSatisfied;
        }

        private class FailedFetchHistory {
            private final AtomicInteger numOfAttempts = new AtomicInteger();
            private long previousAttemptTime;

            private FailedFetchHistory(long previousAttemptTime) {
                this.previousAttemptTime = previousAttemptTime;
            }

            private int getNumOfAttempts() {
                return this.numOfAttempts.get();
            }

            private long getPreviousAttemptTime() {
                return this.previousAttemptTime;
            }

            private void setPreviousAttemptTime(long previousAttemptTime) {
                this.previousAttemptTime = previousAttemptTime;
            }

            private void incrementNumOfAttempts() {
                this.numOfAttempts.incrementAndGet();
            }
        }
    }
}

