/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics.kafka;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigMergeable;
import java.io.Closeable;
import java.io.IOException;
import java.util.Properties;
import org.apache.avro.specific.SpecificRecord;
import org.apache.gobblin.metrics.MetricReport;
import org.apache.gobblin.metrics.kafka.Pusher;
import org.apache.gobblin.metrics.kafka.PusherUtils;
import org.apache.gobblin.metrics.reporter.MetricReportReporter;
import org.apache.gobblin.metrics.reporter.util.AvroJsonSerializer;
import org.apache.gobblin.metrics.reporter.util.AvroSerializer;
import org.apache.gobblin.metrics.reporter.util.FixedSchemaVersionWriter;
import org.apache.gobblin.metrics.reporter.util.SchemaVersionWriter;
import org.apache.gobblin.util.ClassAliasResolver;
import org.apache.gobblin.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaReporter
extends MetricReportReporter {
    private static final Logger log = LoggerFactory.getLogger(KafkaReporter.class);
    public static final String SCHEMA_VERSION_WRITER_TYPE = "metrics.kafka.schemaVersionWriterType";
    private static final String METRICS_KAFKA_PREFIX = "metrics.kafka";
    protected final AvroSerializer<MetricReport> serializer;
    protected final Pusher kafkaPusher;

    protected KafkaReporter(Builder<?> builder, Config config) throws IOException {
        super(builder, config);
        FixedSchemaVersionWriter versionWriter;
        if (config.hasPath(SCHEMA_VERSION_WRITER_TYPE)) {
            try {
                ClassAliasResolver resolver = new ClassAliasResolver(SchemaVersionWriter.class);
                Class klazz = resolver.resolveClass(config.getString(SCHEMA_VERSION_WRITER_TYPE));
                versionWriter = (SchemaVersionWriter)klazz.newInstance();
            }
            catch (ReflectiveOperationException roe) {
                throw new IOException("Could not instantiate version writer.", roe);
            }
        } else {
            versionWriter = new FixedSchemaVersionWriter();
        }
        log.info("Schema version writer: " + versionWriter.getClass().getName());
        this.serializer = (AvroSerializer)this.closer.register(this.createSerializer((SchemaVersionWriter)versionWriter));
        if (builder.kafkaPusher.isPresent()) {
            this.kafkaPusher = (Pusher)builder.kafkaPusher.get();
        } else {
            Config kafkaConfig = ConfigUtils.getConfigOrEmpty((Config)config, (String)"metrics.reporting.kafka.config").withFallback((ConfigMergeable)ConfigUtils.getConfigOrEmpty((Config)config, (String)"gobblin.kafka.sharedConfig"));
            String pusherClassName = ConfigUtils.getString((Config)config, (String)"metrics.reporting.kafkaPusherClass", (String)"org.apache.gobblin.metrics.kafka.KafkaPusher");
            this.kafkaPusher = PusherUtils.getPusher(pusherClassName, builder.brokers, builder.topic, (Optional<Config>)Optional.of((Object)kafkaConfig));
        }
        this.closer.register((Closeable)this.kafkaPusher);
    }

    protected AvroSerializer<MetricReport> createSerializer(SchemaVersionWriter schemaVersionWriter) throws IOException {
        return new AvroJsonSerializer(MetricReport.SCHEMA$, schemaVersionWriter);
    }

    public static Config getKafkaAndMetricsConfigFromProperties(Properties props) {
        return ConfigUtils.propertiesToConfig((Properties)props, (Optional)Optional.of((Object)"metrics.")).withFallback((ConfigMergeable)ConfigUtils.propertiesToConfig((Properties)props, (Optional)Optional.of((Object)"gobblin.kafka.sharedConfig")));
    }

    protected void emitReport(MetricReport report) {
        this.kafkaPusher.pushMessages(Lists.newArrayList((Object[])new byte[][]{this.serializer.serializeRecord((SpecificRecord)report)}));
    }

    public static abstract class Builder<T extends MetricReportReporter.Builder<T>>
    extends MetricReportReporter.Builder<T> {
        protected String brokers;
        protected String topic;
        protected Optional<Pusher> kafkaPusher;

        protected Builder() {
            this.name = "KafkaReporter";
            this.kafkaPusher = Optional.absent();
        }

        public T withKafkaPusher(Pusher pusher) {
            this.kafkaPusher = Optional.of((Object)pusher);
            return (T)((MetricReportReporter.Builder)this.self());
        }

        public KafkaReporter build(String brokers, String topic, Properties props) throws IOException {
            this.brokers = brokers;
            this.topic = topic;
            return new KafkaReporter(this, KafkaReporter.getKafkaAndMetricsConfigFromProperties(props));
        }
    }

    public static class BuilderImpl
    extends Builder<BuilderImpl> {
        protected BuilderImpl self() {
            return this;
        }
    }

    public static class BuilderFactory {
        public static BuilderImpl newBuilder() {
            return new BuilderImpl();
        }
    }
}

