/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics;

import java.util.Properties;
import org.apache.gobblin.configuration.ConfigurationKeys;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.kafka.KafkaAvroEventReporter;
import org.apache.gobblin.metrics.kafka.KafkaAvroReporter;
import org.apache.gobblin.metrics.kafka.KafkaAvroSchemaRegistry;
import org.apache.gobblin.metrics.kafka.KafkaEventReporter;
import org.apache.gobblin.metrics.kafka.KafkaReporter;

public enum KafkaReportingFormats {
    AVRO,
    JSON;


    public KafkaReporter.Builder<?> metricReporterBuilder(Properties properties) {
        switch (this) {
            case AVRO: {
                KafkaAvroReporter.BuilderImpl builder = KafkaAvroReporter.BuilderFactory.newBuilder();
                if (Boolean.valueOf(properties.getProperty("metrics.reporting.kafka.avro.use.schema.registry", ConfigurationKeys.DEFAULT_METRICS_REPORTING_KAFKA_USE_SCHEMA_REGISTRY)).booleanValue()) {
                    builder.withSchemaRegistry(new KafkaAvroSchemaRegistry(properties));
                }
                return builder;
            }
            case JSON: {
                return KafkaReporter.BuilderFactory.newBuilder();
            }
        }
        throw new IllegalArgumentException("KafkaReportingFormat not recognized.");
    }

    public KafkaEventReporter.Builder<?> eventReporterBuilder(MetricContext context, Properties properties) {
        switch (this) {
            case AVRO: {
                KafkaAvroEventReporter.BuilderImpl builder = KafkaAvroEventReporter.Factory.forContext(context);
                if (Boolean.valueOf(properties.getProperty("metrics.reporting.kafka.avro.use.schema.registry", ConfigurationKeys.DEFAULT_METRICS_REPORTING_KAFKA_USE_SCHEMA_REGISTRY)).booleanValue()) {
                    builder.withSchemaRegistry(new KafkaAvroSchemaRegistry(properties));
                }
                return builder;
            }
            case JSON: {
                return KafkaEventReporter.Factory.forContext(context);
            }
        }
        throw new IllegalArgumentException("KafkaReportingFormat not recognized.");
    }
}

