/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.kafka.writer;

import com.typesafe.config.Config;
import java.io.IOException;
import java.util.Properties;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.gobblin.writer.AsyncDataWriter;
import org.apache.gobblin.writer.AsyncWriterManager;
import org.apache.gobblin.writer.DataWriter;
import org.apache.gobblin.writer.DataWriterBuilder;

public abstract class AbstractKafkaDataWriterBuilder<S, D>
extends DataWriterBuilder<S, D> {
    protected abstract AsyncDataWriter<D> getAsyncDataWriter(Properties var1);

    public DataWriter<D> build() throws IOException {
        State state = this.destination.getProperties();
        Properties taskProps = state.getProperties();
        Config config = ConfigUtils.propertiesToConfig((Properties)taskProps);
        long commitTimeoutMillis = ConfigUtils.getLong((Config)config, (String)"writer.kafka.commitTimeoutMillis", (Long)60000L);
        long commitStepWaitTimeMillis = ConfigUtils.getLong((Config)config, (String)"writer.kafka.commitStepWaitTimeMillis", (Long)500L);
        double failureAllowance = ConfigUtils.getDouble((Config)config, (String)"writer.kafka.failureAllowancePercentage", (double)20.0) / 100.0;
        return AsyncWriterManager.builder().config(config).commitTimeoutMillis(commitTimeoutMillis).commitStepWaitTimeInMillis(commitStepWaitTimeMillis).failureAllowanceRatio(failureAllowance).retriesEnabled(false).asyncDataWriter(this.getAsyncDataWriter(taskProps)).build();
    }
}

