/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.tools.ClusterVerifiers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.helix.PropertyKey;
import org.apache.helix.controller.rebalancer.AbstractRebalancer;
import org.apache.helix.controller.stages.ClusterDataCache;
import org.apache.helix.manager.zk.ZkClient;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.Partition;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.tools.ClusterVerifiers.ZkHelixClusterVerifier;
import org.apache.log4j.Logger;

public class StrictMatchExternalViewVerifier
extends ZkHelixClusterVerifier {
    private static Logger LOG = Logger.getLogger(StrictMatchExternalViewVerifier.class);
    private final Set<String> _resources;
    private final Set<String> _expectLiveInstances;

    public StrictMatchExternalViewVerifier(String zkAddr, String clusterName, Set<String> resources, Set<String> expectLiveInstances) {
        super(zkAddr, clusterName);
        this._resources = resources;
        this._expectLiveInstances = expectLiveInstances;
    }

    public StrictMatchExternalViewVerifier(ZkClient zkClient, String clusterName, Set<String> resources, Set<String> expectLiveInstances) {
        super(zkClient, clusterName);
        this._resources = resources;
        this._expectLiveInstances = expectLiveInstances;
    }

    @Override
    public boolean verify(long timeout) {
        return this.verifyByZkCallback(timeout);
    }

    @Override
    public boolean verifyByZkCallback(long timeout) {
        ArrayList<ZkHelixClusterVerifier.ClusterVerifyTrigger> triggers = new ArrayList<ZkHelixClusterVerifier.ClusterVerifyTrigger>();
        if (this._resources != null && !this._resources.isEmpty()) {
            for (String resource : this._resources) {
                triggers.add(new ZkHelixClusterVerifier.ClusterVerifyTrigger(this._keyBuilder.idealStates(resource), true, false, false));
                triggers.add(new ZkHelixClusterVerifier.ClusterVerifyTrigger(this._keyBuilder.externalView(resource), true, false, false));
            }
        } else {
            triggers.add(new ZkHelixClusterVerifier.ClusterVerifyTrigger(this._keyBuilder.idealStates(), false, true, true));
            triggers.add(new ZkHelixClusterVerifier.ClusterVerifyTrigger(this._keyBuilder.externalViews(), false, true, true));
        }
        return this.verifyByCallback(timeout, triggers);
    }

    @Override
    protected boolean verifyState() {
        try {
            Set<String> actualLiveNodes;
            PropertyKey.Builder keyBuilder = this._accessor.keyBuilder();
            ClusterDataCache cache = new ClusterDataCache();
            cache.refresh(this._accessor);
            Map<String, IdealState> idealStates = cache.getIdealStates();
            if (idealStates == null) {
                idealStates = Collections.emptyMap();
            }
            Iterator<Map.Entry<String, IdealState>> it = idealStates.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, IdealState> pair = it.next();
                if (!pair.getValue().getStateModelDefRef().equals("Task")) continue;
                it.remove();
            }
            if (this._expectLiveInstances != null && !this._expectLiveInstances.isEmpty() && !this._expectLiveInstances.equals(actualLiveNodes = cache.getLiveInstances().keySet())) {
                return false;
            }
            Map<String, Object> extViews = this._accessor.getChildValuesMap(keyBuilder.externalViews());
            if (extViews == null) {
                extViews = Collections.emptyMap();
            }
            if (this._resources != null && !this._resources.isEmpty()) {
                idealStates.keySet().retainAll(this._resources);
                extViews.keySet().retainAll(this._resources);
            }
            for (String resource : extViews.keySet()) {
                if (idealStates.containsKey(resource)) continue;
                idealStates.put(resource, new IdealState(resource));
            }
            for (String resourceName : idealStates.keySet()) {
                ExternalView extView = (ExternalView)extViews.get(resourceName);
                IdealState idealState = idealStates.get(resourceName);
                if (extView == null) {
                    if (idealState.isExternalViewDisabled()) continue;
                    LOG.debug((Object)("externalView for " + resourceName + " is not available"));
                    return false;
                }
                boolean result = this.verifyExternalView(cache, extView, idealState);
                if (result) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            LOG.error((Object)"exception in verification", (Throwable)e);
            return false;
        }
    }

    private boolean verifyExternalView(ClusterDataCache dataCache, ExternalView externalView, IdealState idealState) {
        Map<String, Map<String, String>> idealPartitionState;
        Map<String, Map<String, String>> mappingInExtview = externalView.getRecord().getMapFields();
        switch (idealState.getRebalanceMode()) {
            case FULL_AUTO: {
                return true;
            }
            case SEMI_AUTO: 
            case USER_DEFINED: {
                idealPartitionState = this.computeIdealPartitionState(dataCache, idealState);
                break;
            }
            case CUSTOMIZED: {
                idealPartitionState = idealState.getRecord().getMapFields();
                break;
            }
            default: {
                return true;
            }
        }
        return mappingInExtview.equals(idealPartitionState);
    }

    private Map<String, Map<String, String>> computeIdealPartitionState(ClusterDataCache cache, IdealState idealState) {
        String stateModelDefName = idealState.getStateModelDefRef();
        StateModelDefinition stateModelDef = cache.getStateModelDef(stateModelDefName);
        HashMap<String, Map<String, String>> idealPartitionState = new HashMap<String, Map<String, String>>();
        HashSet<String> liveEnabledInstances = new HashSet<String>(cache.getLiveInstances().keySet());
        liveEnabledInstances.removeAll(cache.getDisabledInstances());
        for (String partition : idealState.getPartitionSet()) {
            List<String> preferenceList = AbstractRebalancer.getPreferenceList(new Partition(partition), idealState, liveEnabledInstances);
            Map<String, String> idealMapping = this.computeIdealMapping(preferenceList, stateModelDef, liveEnabledInstances);
            idealPartitionState.put(partition, idealMapping);
        }
        return idealPartitionState;
    }

    private Map<String, String> computeIdealMapping(List<String> instancePreferenceList, StateModelDefinition stateModelDef, Set<String> liveEnabledInstances) {
        HashMap<String, String> instanceStateMap = new HashMap<String, String>();
        if (instancePreferenceList == null) {
            return instanceStateMap;
        }
        List<String> statesPriorityList = stateModelDef.getStatesPriorityList();
        boolean[] assigned = new boolean[instancePreferenceList.size()];
        block2: for (String state : statesPriorityList) {
            String num = stateModelDef.getNumInstancesPerState(state);
            int stateCount = -1;
            if ("N".equals(num)) {
                stateCount = liveEnabledInstances.size();
            } else if ("R".equals(num)) {
                stateCount = instancePreferenceList.size();
            } else {
                try {
                    stateCount = Integer.parseInt(num);
                }
                catch (Exception e) {
                    LOG.error((Object)("Invalid count for state:" + state + " ,count=" + num));
                }
            }
            if (stateCount <= 0) continue;
            int count = 0;
            for (int i = 0; i < instancePreferenceList.size(); ++i) {
                String instanceName = instancePreferenceList.get(i);
                if (assigned[i]) continue;
                instanceStateMap.put(instanceName, state);
                assigned[i] = true;
                if (++count == stateCount) continue block2;
            }
        }
        return instanceStateMap;
    }

    public String toString() {
        String verifierName = this.getClass().getSimpleName();
        return verifierName + "(" + this._clusterName + "@" + this._zkClient.getServers() + "@resources[" + this._resources != null ? Arrays.toString(this._resources.toArray()) : "])";
    }

    public static class Builder {
        private String _clusterName;
        private Set<String> _resources;
        private Set<String> _expectLiveInstances;
        private String _zkAddr;
        private ZkClient _zkClient;

        public StrictMatchExternalViewVerifier build() {
            if (this._clusterName == null || this._zkAddr == null && this._zkClient == null) {
                throw new IllegalArgumentException("Cluster name or zookeeper info is missing!");
            }
            if (this._zkClient != null) {
                return new StrictMatchExternalViewVerifier(this._zkClient, this._clusterName, this._resources, this._expectLiveInstances);
            }
            return new StrictMatchExternalViewVerifier(this._zkAddr, this._clusterName, this._resources, this._expectLiveInstances);
        }

        public Builder(String clusterName) {
            this._clusterName = clusterName;
        }

        public String getClusterName() {
            return this._clusterName;
        }

        public Set<String> getResources() {
            return this._resources;
        }

        public Builder setResources(Set<String> resources) {
            this._resources = resources;
            return this;
        }

        public Set<String> getExpectLiveInstances() {
            return this._expectLiveInstances;
        }

        public Builder setExpectLiveInstances(Set<String> expectLiveInstances) {
            this._expectLiveInstances = expectLiveInstances;
            return this;
        }

        public String getZkAddr() {
            return this._zkAddr;
        }

        public Builder setZkAddr(String zkAddr) {
            this._zkAddr = zkAddr;
            return this;
        }

        public ZkClient getZkClient() {
            return this._zkClient;
        }

        public Builder setZkClient(ZkClient zkClient) {
            this._zkClient = zkClient;
            return this;
        }
    }
}

