/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.task;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.helix.HelixProperty;
import org.apache.helix.model.ResourceConfig;
import org.apache.helix.task.TaskConfig;
import org.apache.helix.task.TaskUtil;
import org.apache.helix.task.beans.JobBean;
import org.apache.helix.task.beans.TaskBean;

public class JobConfig
extends ResourceConfig {
    public static final long DEFAULT_TIMEOUT = Long.MAX_VALUE;
    public static final long DEFAULT_TIMEOUT_PER_TASK = 3600000L;
    public static final long DEFAULT_TASK_RETRY_DELAY = -1L;
    public static final int DEFAULT_MAX_ATTEMPTS_PER_TASK = 10;
    public static final int DEFAULT_NUM_CONCURRENT_TASKS_PER_INSTANCE = 1;
    public static final int DEFAULT_FAILURE_THRESHOLD = 0;
    public static final int DEFAULT_MAX_FORCED_REASSIGNMENTS_PER_TASK = 0;
    public static final boolean DEFAULT_DISABLE_EXTERNALVIEW = false;
    public static final boolean DEFAULT_IGNORE_DEPENDENT_JOB_FAILURE = false;
    public static final int DEFAULT_NUMBER_OF_TASKS = 0;
    public static final long DEFAULT_JOB_EXECUTION_START_TIME = -1L;
    public static final long DEFAULT_Job_EXECUTION_DELAY_TIME = -1L;
    public static final boolean DEFAULT_REBALANCE_RUNNING_TASK = false;

    public JobConfig(HelixProperty property) {
        super(property.getRecord());
    }

    public JobConfig(String jobId, JobConfig jobConfig) {
        this(jobConfig.getWorkflow(), jobConfig.getTargetResource(), jobConfig.getTargetPartitions(), jobConfig.getTargetPartitionStates(), jobConfig.getCommand(), jobConfig.getJobCommandConfigMap(), jobConfig.getTimeout(), jobConfig.getTimeoutPerTask(), jobConfig.getNumConcurrentTasksPerInstance(), jobConfig.getMaxAttemptsPerTask(), jobConfig.getMaxAttemptsPerTask(), jobConfig.getFailureThreshold(), jobConfig.getTaskRetryDelay(), jobConfig.isDisableExternalView(), jobConfig.isIgnoreDependentJobFailure(), jobConfig.getTaskConfigMap(), jobConfig.getJobType(), jobConfig.getInstanceGroupTag(), jobConfig.getExecutionDelay(), jobConfig.getExecutionStart(), jobId, jobConfig.getExpiry(), jobConfig.isRebalanceRunningTask());
    }

    private JobConfig(String workflow, String targetResource, List<String> targetPartitions, Set<String> targetPartitionStates, String command, Map<String, String> jobCommandConfigMap, long timeout, long timeoutPerTask, int numConcurrentTasksPerInstance, int maxAttemptsPerTask, int maxForcedReassignmentsPerTask, int failureThreshold, long retryDelay, boolean disableExternalView, boolean ignoreDependentJobFailure, Map<String, TaskConfig> taskConfigMap, String jobType, String instanceGroupTag, long executionDelay, long executionStart, String jobId, long expiry, boolean rebalanceRunningTask) {
        super(jobId);
        String serializedConfig;
        this.putSimpleConfig(JobConfigProperty.WorkflowID.name(), workflow);
        this.putSimpleConfig(JobConfigProperty.JobID.name(), jobId);
        if (command != null) {
            this.putSimpleConfig(JobConfigProperty.Command.name(), command);
        }
        if (jobCommandConfigMap != null && (serializedConfig = TaskUtil.serializeJobCommandConfigMap(jobCommandConfigMap)) != null) {
            this.putSimpleConfig(JobConfigProperty.JobCommandConfig.name(), serializedConfig);
        }
        if (targetResource != null) {
            this.putSimpleConfig(JobConfigProperty.TargetResource.name(), targetResource);
        }
        if (targetPartitionStates != null) {
            this.putSimpleConfig(JobConfigProperty.TargetPartitionStates.name(), Joiner.on((String)",").join(targetPartitionStates));
        }
        if (targetPartitions != null) {
            this.putSimpleConfig(JobConfigProperty.TargetPartitions.name(), Joiner.on((String)",").join(targetPartitions));
        }
        if (retryDelay > 0L) {
            this.getRecord().setLongField(JobConfigProperty.TaskRetryDelay.name(), retryDelay);
        }
        if (executionDelay > 0L) {
            this.getRecord().setLongField(JobConfigProperty.DelayTime.name(), executionDelay);
        }
        if (executionStart > 0L) {
            this.getRecord().setLongField(JobConfigProperty.StartTime.name(), executionStart);
        }
        this.getRecord().setLongField(JobConfigProperty.Timeout.name(), timeout);
        this.getRecord().setLongField(JobConfigProperty.TimeoutPerPartition.name(), timeoutPerTask);
        this.getRecord().setIntField(JobConfigProperty.MaxAttemptsPerTask.name(), maxAttemptsPerTask);
        this.getRecord().setIntField(JobConfigProperty.MaxForcedReassignmentsPerTask.name(), maxForcedReassignmentsPerTask);
        this.getRecord().setIntField(JobConfigProperty.FailureThreshold.name(), failureThreshold);
        this.getRecord().setBooleanField(JobConfigProperty.DisableExternalView.name(), disableExternalView);
        this.getRecord().setIntField(JobConfigProperty.ConcurrentTasksPerInstance.name(), numConcurrentTasksPerInstance);
        this.getRecord().setBooleanField(JobConfigProperty.IgnoreDependentJobFailure.name(), ignoreDependentJobFailure);
        if (jobType != null) {
            this.putSimpleConfig(JobConfigProperty.JobType.name(), jobType);
        }
        if (instanceGroupTag != null) {
            this.putSimpleConfig(JobConfigProperty.InstanceGroupTag.name(), instanceGroupTag);
        }
        if (taskConfigMap != null) {
            for (TaskConfig taskConfig : taskConfigMap.values()) {
                this.putMapConfig(taskConfig.getId(), taskConfig.getConfigMap());
            }
        }
        if (expiry > 0L) {
            this.getRecord().setLongField(JobConfigProperty.Expiry.name(), expiry);
        }
        this.putSimpleConfig(ResourceConfig.ResourceConfigProperty.MONITORING_DISABLED.toString(), String.valueOf(true));
        this.getRecord().setBooleanField(JobConfigProperty.RebalanceRunningTask.name(), rebalanceRunningTask);
    }

    public String getWorkflow() {
        return this.simpleConfigContains(JobConfigProperty.WorkflowID.name()) ? this.getSimpleConfig(JobConfigProperty.WorkflowID.name()) : "UNSPECIFIED";
    }

    public String getJobId() {
        return this.getSimpleConfig(JobConfigProperty.JobID.name());
    }

    public String getTargetResource() {
        return this.getSimpleConfig(JobConfigProperty.TargetResource.name());
    }

    public List<String> getTargetPartitions() {
        return this.simpleConfigContains(JobConfigProperty.TargetPartitions.name()) ? Arrays.asList(this.getSimpleConfig(JobConfigProperty.TargetPartitions.name()).split(",")) : null;
    }

    public Set<String> getTargetPartitionStates() {
        if (this.simpleConfigContains(JobConfigProperty.TargetPartitionStates.name())) {
            return new HashSet<String>(Arrays.asList(this.getSimpleConfig(JobConfigProperty.TargetPartitionStates.name()).split(",")));
        }
        return null;
    }

    public String getCommand() {
        return this.getSimpleConfig(JobConfigProperty.Command.name());
    }

    public Map<String, String> getJobCommandConfigMap() {
        return this.simpleConfigContains(JobConfigProperty.JobCommandConfig.name()) ? TaskUtil.deserializeJobCommandConfigMap(this.getSimpleConfig(JobConfigProperty.JobCommandConfig.name())) : null;
    }

    public long getTimeout() {
        return this.getRecord().getLongField(JobConfigProperty.Timeout.name(), Long.MAX_VALUE);
    }

    public long getTimeoutPerTask() {
        return this.getRecord().getLongField(JobConfigProperty.TimeoutPerPartition.name(), 3600000L);
    }

    public int getNumConcurrentTasksPerInstance() {
        return this.getRecord().getIntField(JobConfigProperty.ConcurrentTasksPerInstance.name(), 1);
    }

    public int getMaxAttemptsPerTask() {
        return this.getRecord().getIntField(JobConfigProperty.MaxAttemptsPerTask.name(), 10);
    }

    public int getFailureThreshold() {
        return this.getRecord().getIntField(JobConfigProperty.FailureThreshold.name(), 0);
    }

    public long getTaskRetryDelay() {
        return this.getRecord().getLongField(JobConfigProperty.TaskRetryDelay.name(), -1L);
    }

    public long getExecutionDelay() {
        return this.getRecord().getLongField(JobConfigProperty.DelayTime.name(), -1L);
    }

    public long getExecutionStart() {
        return this.getRecord().getLongField(JobConfigProperty.StartTime.name(), -1L);
    }

    public boolean isDisableExternalView() {
        return this.getRecord().getBooleanField(JobConfigProperty.DisableExternalView.name(), false);
    }

    public boolean isIgnoreDependentJobFailure() {
        return this.getRecord().getBooleanField(JobConfigProperty.IgnoreDependentJobFailure.name(), false);
    }

    public Map<String, TaskConfig> getTaskConfigMap() {
        HashMap<String, TaskConfig> taskConfigMap = new HashMap<String, TaskConfig>();
        for (Map.Entry<String, Map<String, String>> entry : this.getMapConfigs().entrySet()) {
            taskConfigMap.put(entry.getKey(), new TaskConfig(null, entry.getValue(), entry.getKey(), null));
        }
        return taskConfigMap;
    }

    public TaskConfig getTaskConfig(String id) {
        return new TaskConfig(null, this.getMapConfig(id), id, null);
    }

    public Map<String, String> getResourceConfigMap() {
        return this.getSimpleConfigs();
    }

    public String getJobType() {
        return this.getSimpleConfig(JobConfigProperty.JobType.name());
    }

    @Override
    public String getInstanceGroupTag() {
        return this.getSimpleConfig(JobConfigProperty.InstanceGroupTag.name());
    }

    public Long getExpiry() {
        return this.getRecord().getLongField(JobConfigProperty.Expiry.name(), 86400000L);
    }

    public boolean isRebalanceRunningTask() {
        return this.getRecord().getBooleanField(JobConfigProperty.RebalanceRunningTask.name(), false);
    }

    public static JobConfig fromHelixProperty(HelixProperty property) throws IllegalArgumentException {
        Map<String, String> configs = property.getRecord().getSimpleFields();
        return Builder.fromMap(configs).build();
    }

    public static class Builder {
        private String _workflow;
        private String _jobId;
        private String _targetResource;
        private String _jobType;
        private String _instanceGroupTag;
        private List<String> _targetPartitions;
        private Set<String> _targetPartitionStates;
        private String _command;
        private Map<String, String> _commandConfig;
        private Map<String, TaskConfig> _taskConfigMap = Maps.newHashMap();
        private long _timeout = Long.MAX_VALUE;
        private long _timeoutPerTask = 3600000L;
        private int _numConcurrentTasksPerInstance = 1;
        private int _maxAttemptsPerTask = 10;
        private int _maxForcedReassignmentsPerTask = 0;
        private int _failureThreshold = 0;
        private long _retryDelay = -1L;
        private long _executionStart = -1L;
        private long _executionDelay = -1L;
        private long _expiry = 86400000L;
        private boolean _disableExternalView = false;
        private boolean _ignoreDependentJobFailure = false;
        private int _numberOfTasks = 0;
        private boolean _rebalanceRunningTask = false;

        public JobConfig build() {
            if (this._targetResource == null && this._taskConfigMap.isEmpty()) {
                for (int i = 0; i < this._numberOfTasks; ++i) {
                    TaskConfig taskConfig = new TaskConfig(null, null);
                    this._taskConfigMap.put(taskConfig.getId(), taskConfig);
                }
            }
            if (this._jobId == null) {
                this._jobId = "";
            }
            this.validate();
            return new JobConfig(this._workflow, this._targetResource, this._targetPartitions, this._targetPartitionStates, this._command, this._commandConfig, this._timeout, this._timeoutPerTask, this._numConcurrentTasksPerInstance, this._maxAttemptsPerTask, this._maxForcedReassignmentsPerTask, this._failureThreshold, this._retryDelay, this._disableExternalView, this._ignoreDependentJobFailure, this._taskConfigMap, this._jobType, this._instanceGroupTag, this._executionDelay, this._executionStart, this._jobId, this._expiry, this._rebalanceRunningTask);
        }

        public static Builder fromMap(Map<String, String> cfg) {
            Builder b = new Builder();
            if (cfg.containsKey(JobConfigProperty.WorkflowID.name())) {
                b.setWorkflow(cfg.get(JobConfigProperty.WorkflowID.name()));
            }
            if (cfg.containsKey(JobConfigProperty.JobID.name())) {
                b.setJobId(cfg.get(JobConfigProperty.JobID.name()));
            }
            if (cfg.containsKey(JobConfigProperty.TargetResource.name())) {
                b.setTargetResource(cfg.get(JobConfigProperty.TargetResource.name()));
            }
            if (cfg.containsKey(JobConfigProperty.TargetPartitions.name())) {
                b.setTargetPartitions(Builder.csvToStringList(cfg.get(JobConfigProperty.TargetPartitions.name())));
            }
            if (cfg.containsKey(JobConfigProperty.TargetPartitionStates.name())) {
                b.setTargetPartitionStates(new HashSet<String>(Arrays.asList(cfg.get(JobConfigProperty.TargetPartitionStates.name()).split(","))));
            }
            if (cfg.containsKey(JobConfigProperty.Command.name())) {
                b.setCommand(cfg.get(JobConfigProperty.Command.name()));
            }
            if (cfg.containsKey(JobConfigProperty.JobCommandConfig.name())) {
                Map<String, String> commandConfigMap = TaskUtil.deserializeJobCommandConfigMap(cfg.get(JobConfigProperty.JobCommandConfig.name()));
                b.setJobCommandConfigMap(commandConfigMap);
            }
            if (cfg.containsKey(JobConfigProperty.Timeout.name())) {
                b.setTimeout(Long.parseLong(cfg.get(JobConfigProperty.Timeout.name())));
            }
            if (cfg.containsKey(JobConfigProperty.TimeoutPerPartition.name())) {
                b.setTimeoutPerTask(Long.parseLong(cfg.get(JobConfigProperty.TimeoutPerPartition.name())));
            }
            if (cfg.containsKey(JobConfigProperty.ConcurrentTasksPerInstance.name())) {
                b.setNumConcurrentTasksPerInstance(Integer.parseInt(cfg.get(JobConfigProperty.ConcurrentTasksPerInstance.name())));
            }
            if (cfg.containsKey(JobConfigProperty.MaxAttemptsPerTask.name())) {
                b.setMaxAttemptsPerTask(Integer.parseInt(cfg.get(JobConfigProperty.MaxAttemptsPerTask.name())));
            }
            if (cfg.containsKey(JobConfigProperty.FailureThreshold.name())) {
                b.setFailureThreshold(Integer.parseInt(cfg.get(JobConfigProperty.FailureThreshold.name())));
            }
            if (cfg.containsKey(JobConfigProperty.TaskRetryDelay.name())) {
                b.setTaskRetryDelay(Long.parseLong(cfg.get(JobConfigProperty.TaskRetryDelay.name())));
            }
            if (cfg.containsKey(JobConfigProperty.DelayTime.name())) {
                b.setExecutionDelay(Long.parseLong(cfg.get(JobConfigProperty.DelayTime.name())));
            }
            if (cfg.containsKey(JobConfigProperty.StartTime.name())) {
                b.setExecutionStart(Long.parseLong(cfg.get(JobConfigProperty.StartTime.name())));
            }
            if (cfg.containsKey(JobConfigProperty.DisableExternalView.name())) {
                b.setDisableExternalView(Boolean.valueOf(cfg.get(JobConfigProperty.DisableExternalView.name())));
            }
            if (cfg.containsKey(JobConfigProperty.IgnoreDependentJobFailure.name())) {
                b.setIgnoreDependentJobFailure(Boolean.valueOf(cfg.get(JobConfigProperty.IgnoreDependentJobFailure.name())));
            }
            if (cfg.containsKey(JobConfigProperty.JobType.name())) {
                b.setJobType(cfg.get(JobConfigProperty.JobType.name()));
            }
            if (cfg.containsKey(JobConfigProperty.InstanceGroupTag.name())) {
                b.setInstanceGroupTag(cfg.get(JobConfigProperty.InstanceGroupTag.name()));
            }
            if (cfg.containsKey(JobConfigProperty.Expiry.name())) {
                b.setExpiry(Long.valueOf(cfg.get(JobConfigProperty.Expiry.name())));
            }
            if (cfg.containsKey(JobConfigProperty.RebalanceRunningTask.name())) {
                b.setRebalanceRunningTask(Boolean.valueOf(cfg.get(JobConfigProperty.RebalanceRunningTask.name())));
            }
            return b;
        }

        public Builder setWorkflow(String v) {
            this._workflow = v;
            return this;
        }

        public Builder setJobId(String v) {
            this._jobId = v;
            return this;
        }

        public Builder setTargetResource(String v) {
            this._targetResource = v;
            return this;
        }

        public Builder setTargetPartitions(List<String> v) {
            this._targetPartitions = ImmutableList.copyOf(v);
            return this;
        }

        public Builder setTargetPartitionStates(Set<String> v) {
            this._targetPartitionStates = ImmutableSet.copyOf(v);
            return this;
        }

        public Builder setCommand(String v) {
            this._command = v;
            return this;
        }

        public Builder setNumberOfTasks(int v) {
            this._numberOfTasks = v;
            return this;
        }

        public Builder setJobCommandConfigMap(Map<String, String> v) {
            this._commandConfig = v;
            return this;
        }

        public Builder setTimeout(long v) {
            this._timeout = v;
            return this;
        }

        public Builder setTimeoutPerTask(long v) {
            this._timeoutPerTask = v;
            return this;
        }

        public Builder setNumConcurrentTasksPerInstance(int v) {
            this._numConcurrentTasksPerInstance = v;
            return this;
        }

        public Builder setMaxAttemptsPerTask(int v) {
            this._maxAttemptsPerTask = v;
            return this;
        }

        @Deprecated
        public Builder setMaxForcedReassignmentsPerTask(int v) {
            this._maxForcedReassignmentsPerTask = v;
            return this;
        }

        public Builder setFailureThreshold(int v) {
            this._failureThreshold = v;
            return this;
        }

        public Builder setTaskRetryDelay(long v) {
            this._retryDelay = v;
            return this;
        }

        public Builder setExecutionDelay(long v) {
            this._executionDelay = v;
            return this;
        }

        public Builder setExecutionStart(long v) {
            this._executionStart = v;
            return this;
        }

        public Builder setDisableExternalView(boolean disableExternalView) {
            this._disableExternalView = disableExternalView;
            return this;
        }

        public Builder setIgnoreDependentJobFailure(boolean ignoreDependentJobFailure) {
            this._ignoreDependentJobFailure = ignoreDependentJobFailure;
            return this;
        }

        public Builder addTaskConfigs(List<TaskConfig> taskConfigs) {
            if (taskConfigs != null) {
                for (TaskConfig taskConfig : taskConfigs) {
                    this._taskConfigMap.put(taskConfig.getId(), taskConfig);
                }
            }
            return this;
        }

        public Builder addTaskConfigMap(Map<String, TaskConfig> taskConfigMap) {
            this._taskConfigMap.putAll(taskConfigMap);
            return this;
        }

        public Builder setJobType(String jobType) {
            this._jobType = jobType;
            return this;
        }

        public Builder setInstanceGroupTag(String instanceGroupTag) {
            this._instanceGroupTag = instanceGroupTag;
            return this;
        }

        public Builder setExpiry(Long expiry) {
            this._expiry = expiry;
            return this;
        }

        public Builder setRebalanceRunningTask(boolean enabled) {
            this._rebalanceRunningTask = enabled;
            return this;
        }

        private void validate() {
            if (this._taskConfigMap.isEmpty() && this._targetResource == null) {
                throw new IllegalArgumentException(String.format("%s cannot be null", new Object[]{JobConfigProperty.TargetResource}));
            }
            if (this._taskConfigMap.isEmpty() && this._targetPartitionStates != null && this._targetPartitionStates.isEmpty()) {
                throw new IllegalArgumentException(String.format("%s cannot be an empty set", new Object[]{JobConfigProperty.TargetPartitionStates}));
            }
            if (this._taskConfigMap.isEmpty()) {
                if (this._command == null) {
                    throw new IllegalArgumentException(String.format("%s cannot be null", new Object[]{JobConfigProperty.Command}));
                }
                if (this._targetResource == null && this._numberOfTasks == 0) {
                    throw new IllegalArgumentException("Either targetResource or numberOfTask should be set");
                }
            }
            if (this._command == null) {
                for (TaskConfig taskConfig : this._taskConfigMap.values()) {
                    if (taskConfig.getCommand() != null) continue;
                    throw new IllegalArgumentException(String.format("Task % command cannot be null", taskConfig.getId()));
                }
            }
            if (this._timeout < 0L) {
                throw new IllegalArgumentException(String.format("%s has invalid value %s", new Object[]{JobConfigProperty.Timeout, this._timeout}));
            }
            if (this._timeoutPerTask < 0L) {
                throw new IllegalArgumentException(String.format("%s has invalid value %s", new Object[]{JobConfigProperty.TimeoutPerPartition, this._timeoutPerTask}));
            }
            if (this._numConcurrentTasksPerInstance < 1) {
                throw new IllegalArgumentException(String.format("%s has invalid value %s", new Object[]{JobConfigProperty.ConcurrentTasksPerInstance, this._numConcurrentTasksPerInstance}));
            }
            if (this._maxAttemptsPerTask < 1) {
                throw new IllegalArgumentException(String.format("%s has invalid value %s", new Object[]{JobConfigProperty.MaxAttemptsPerTask, this._maxAttemptsPerTask}));
            }
            if (this._maxForcedReassignmentsPerTask < 0) {
                throw new IllegalArgumentException(String.format("%s has invalid value %s", new Object[]{JobConfigProperty.MaxForcedReassignmentsPerTask, this._maxForcedReassignmentsPerTask}));
            }
            if (this._failureThreshold < 0) {
                throw new IllegalArgumentException(String.format("%s has invalid value %s", new Object[]{JobConfigProperty.FailureThreshold, this._failureThreshold}));
            }
            if (this._workflow == null) {
                throw new IllegalArgumentException(String.format("%s cannot be null", new Object[]{JobConfigProperty.WorkflowID}));
            }
        }

        public static Builder from(JobBean jobBean) {
            Builder b = new Builder();
            b.setMaxAttemptsPerTask(jobBean.maxAttemptsPerTask).setNumConcurrentTasksPerInstance(jobBean.numConcurrentTasksPerInstance).setTimeout(jobBean.timeout).setTimeoutPerTask(jobBean.timeoutPerPartition).setFailureThreshold(jobBean.failureThreshold).setTaskRetryDelay(jobBean.taskRetryDelay).setDisableExternalView(jobBean.disableExternalView).setIgnoreDependentJobFailure(jobBean.ignoreDependentJobFailure).setNumberOfTasks(jobBean.numberOfTasks).setExecutionDelay(jobBean.executionDelay).setExecutionStart(jobBean.executionStart).setRebalanceRunningTask(jobBean.rebalanceRunningTask);
            if (jobBean.jobCommandConfigMap != null) {
                b.setJobCommandConfigMap(jobBean.jobCommandConfigMap);
            }
            if (jobBean.command != null) {
                b.setCommand(jobBean.command);
            }
            if (jobBean.targetResource != null) {
                b.setTargetResource(jobBean.targetResource);
            }
            if (jobBean.targetPartitionStates != null) {
                b.setTargetPartitionStates(new HashSet<String>(jobBean.targetPartitionStates));
            }
            if (jobBean.targetPartitions != null) {
                b.setTargetPartitions(jobBean.targetPartitions);
            }
            if (jobBean.tasks != null) {
                ArrayList taskConfigs = Lists.newArrayList();
                for (TaskBean task : jobBean.tasks) {
                    taskConfigs.add(TaskConfig.Builder.from(task));
                }
                b.addTaskConfigs(taskConfigs);
            }
            if (jobBean.jobType != null) {
                b.setJobType(jobBean.jobType);
            }
            if (jobBean.instanceGroupTag != null) {
                b.setInstanceGroupTag(jobBean.instanceGroupTag);
            }
            return b;
        }

        private static List<String> csvToStringList(String csv) {
            String[] vals = csv.split(",");
            return Arrays.asList(vals);
        }
    }

    protected static enum JobConfigProperty {
        WorkflowID,
        JobID,
        AssignmentStrategy,
        TargetResource,
        TargetPartitionStates,
        TargetPartitions,
        Command,
        JobCommandConfig,
        Timeout,
        TimeoutPerPartition,
        MaxAttemptsPerTask,
        MaxForcedReassignmentsPerTask,
        ConcurrentTasksPerInstance,
        FailureThreshold,
        TaskRetryDelay,
        IgnoreDependentJobFailure,
        TaskConfigs,
        DisableExternalView,
        JobType,
        InstanceGroupTag,
        DelayTime,
        StartTime,
        Expiry,
        RebalanceRunningTask;

    }
}

