/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.helix.api.config.StateTransitionThrottleConfig;
import org.apache.helix.model.ClusterConfig;
import org.apache.log4j.Logger;

class StateTransitionThrottleController {
    private static Logger logger = Logger.getLogger(StateTransitionThrottleController.class);
    Map<StateTransitionThrottleConfig.RebalanceType, Long> _pendingTransitionAllowedInCluster = new HashMap<StateTransitionThrottleConfig.RebalanceType, Long>();
    Map<String, Map<StateTransitionThrottleConfig.RebalanceType, Long>> _pendingTransitionAllowedPerInstance = new HashMap<String, Map<StateTransitionThrottleConfig.RebalanceType, Long>>();
    Map<String, Map<StateTransitionThrottleConfig.RebalanceType, Long>> _pendingTransitionAllowedPerResource = new HashMap<String, Map<StateTransitionThrottleConfig.RebalanceType, Long>>();
    private boolean _throttleEnabled = false;

    public StateTransitionThrottleController(Set<String> resources, ClusterConfig clusterConfig, Set<String> liveInstances) {
        if (clusterConfig == null) {
            logger.warn((Object)"Cluster config is not found, no throttle config set!");
            return;
        }
        List<StateTransitionThrottleConfig> throttleConfigs = clusterConfig.getStateTransitionThrottleConfigs();
        if (throttleConfigs == null || throttleConfigs.isEmpty()) {
            logger.info((Object)"No throttle config is set!");
            return;
        }
        for (StateTransitionThrottleConfig config : throttleConfigs) {
            switch (config.getThrottleScope()) {
                case CLUSTER: {
                    this._pendingTransitionAllowedInCluster.put(config.getRebalanceType(), config.getMaxPartitionInTransition());
                    this._throttleEnabled = true;
                    break;
                }
                case RESOURCE: {
                    for (String resource : resources) {
                        if (!this._pendingTransitionAllowedPerResource.containsKey(resource)) {
                            this._pendingTransitionAllowedPerResource.put(resource, new HashMap());
                        }
                        this._pendingTransitionAllowedPerResource.get(resource).put(config.getRebalanceType(), config.getMaxPartitionInTransition());
                    }
                    this._throttleEnabled = true;
                    break;
                }
                case INSTANCE: {
                    for (String instance : liveInstances) {
                        if (!this._pendingTransitionAllowedPerInstance.containsKey(instance)) {
                            this._pendingTransitionAllowedPerInstance.put(instance, new HashMap());
                        }
                        this._pendingTransitionAllowedPerInstance.get(instance).put(config.getRebalanceType(), config.getMaxPartitionInTransition());
                    }
                    this._throttleEnabled = true;
                }
            }
        }
    }

    protected boolean isThrottleEnabled() {
        return this._throttleEnabled;
    }

    protected boolean throttleforCluster(StateTransitionThrottleConfig.RebalanceType rebalanceType) {
        Long clusterThrottle = this._pendingTransitionAllowedInCluster.get((Object)rebalanceType);
        return clusterThrottle != null && clusterThrottle <= 0L;
    }

    protected boolean throttleforResource(StateTransitionThrottleConfig.RebalanceType rebalanceType, String resourceName) {
        Long resouceThrottle;
        if (this.throttleforCluster(rebalanceType)) {
            return true;
        }
        return this._pendingTransitionAllowedPerResource.containsKey(resourceName) && (resouceThrottle = this._pendingTransitionAllowedPerResource.get(resourceName).get((Object)rebalanceType)) != null && resouceThrottle <= 0L;
    }

    protected boolean throttleForInstance(StateTransitionThrottleConfig.RebalanceType rebalanceType, String instanceName) {
        Long instanceThrottle;
        if (this.throttleforCluster(rebalanceType)) {
            return true;
        }
        return this._pendingTransitionAllowedPerInstance.containsKey(instanceName) && (instanceThrottle = this._pendingTransitionAllowedPerInstance.get(instanceName).get((Object)rebalanceType)) != null && instanceThrottle <= 0L;
    }

    protected void chargeCluster(StateTransitionThrottleConfig.RebalanceType rebalanceType) {
        Long clusterThrottle;
        if (this._pendingTransitionAllowedInCluster.containsKey((Object)rebalanceType) && (clusterThrottle = this._pendingTransitionAllowedInCluster.get((Object)rebalanceType)) > 0L) {
            this._pendingTransitionAllowedInCluster.put(rebalanceType, clusterThrottle - 1L);
        }
    }

    protected void chargeResource(StateTransitionThrottleConfig.RebalanceType rebalanceType, String resource) {
        Long resouceThrottle;
        if (this._pendingTransitionAllowedPerResource.containsKey(resource) && this._pendingTransitionAllowedPerResource.get(resource).containsKey((Object)rebalanceType) && (resouceThrottle = this._pendingTransitionAllowedPerResource.get(resource).get((Object)rebalanceType)) > 0L) {
            this._pendingTransitionAllowedPerResource.get(resource).put(rebalanceType, resouceThrottle - 1L);
        }
    }

    protected void chargeInstance(StateTransitionThrottleConfig.RebalanceType rebalanceType, String instance) {
        Long instanceThrottle;
        if (this._pendingTransitionAllowedPerInstance.containsKey(instance) && this._pendingTransitionAllowedPerInstance.get(instance).containsKey((Object)rebalanceType) && (instanceThrottle = this._pendingTransitionAllowedPerInstance.get(instance).get((Object)rebalanceType)) > 0L) {
            this._pendingTransitionAllowedPerInstance.get(instance).put(rebalanceType, instanceThrottle - 1L);
        }
    }
}

