/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.helix.HelixManager;
import org.apache.helix.api.config.StateTransitionTimeoutConfig;
import org.apache.helix.controller.pipeline.AbstractBaseStage;
import org.apache.helix.controller.pipeline.StageException;
import org.apache.helix.controller.stages.AttributeName;
import org.apache.helix.controller.stages.ClusterDataCache;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.controller.stages.IntermediateStateOutput;
import org.apache.helix.controller.stages.MessageGenerationOutput;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.Message;
import org.apache.helix.model.Partition;
import org.apache.helix.model.Resource;
import org.apache.helix.model.ResourceConfig;
import org.apache.helix.model.StateModelDefinition;
import org.apache.log4j.Logger;

public class MessageGenerationPhase
extends AbstractBaseStage {
    private static Logger logger = Logger.getLogger(MessageGenerationPhase.class);

    @Override
    public void process(ClusterEvent event) throws Exception {
        HelixManager manager = (HelixManager)event.getAttribute("helixmanager");
        ClusterDataCache cache = (ClusterDataCache)event.getAttribute("ClusterDataCache");
        Map resourceMap = (Map)event.getAttribute(AttributeName.RESOURCES.name());
        CurrentStateOutput currentStateOutput = (CurrentStateOutput)event.getAttribute(AttributeName.CURRENT_STATE.name());
        IntermediateStateOutput intermediateStateOutput = (IntermediateStateOutput)event.getAttribute(AttributeName.INTERMEDIATE_STATE.name());
        if (manager == null || cache == null || resourceMap == null || currentStateOutput == null || intermediateStateOutput == null) {
            throw new StageException("Missing attributes in event:" + event + ". Requires HelixManager|DataCache|RESOURCES|CURRENT_STATE|INTERMEDIATE_STATE");
        }
        Map<String, LiveInstance> liveInstances = cache.getLiveInstances();
        HashMap<String, String> sessionIdMap = new HashMap<String, String>();
        for (LiveInstance liveInstance : liveInstances.values()) {
            sessionIdMap.put(liveInstance.getInstanceName(), liveInstance.getSessionId());
        }
        MessageGenerationOutput output = new MessageGenerationOutput();
        for (String resourceName : resourceMap.keySet()) {
            Resource resource = (Resource)resourceMap.get(resourceName);
            StateModelDefinition stateModelDef = cache.getStateModelDef(resource.getStateModelDefRef());
            for (Partition partition : resource.getPartitions()) {
                Map<String, String> instanceStateMap = intermediateStateOutput.getInstanceStateMap(resourceName, partition);
                HashMap messageMap = new HashMap();
                for (String instanceName : instanceStateMap.keySet()) {
                    int timeout;
                    String desiredState = instanceStateMap.get(instanceName);
                    String currentState = currentStateOutput.getCurrentState(resourceName, partition, instanceName);
                    if (currentState == null) {
                        currentState = stateModelDef.getInitialState();
                    }
                    if (desiredState.equalsIgnoreCase(currentState)) continue;
                    Message pendingMessage = currentStateOutput.getPendingState(resourceName, partition, instanceName);
                    String nextState = stateModelDef.getNextStateForTransition(currentState, desiredState);
                    if (nextState == null) {
                        logger.error((Object)("Unable to find a next state for resource: " + resource.getResourceName() + " partition: " + partition.getPartitionName() + " from stateModelDefinition" + stateModelDef.getClass() + " from:" + currentState + " to:" + desiredState));
                        continue;
                    }
                    Message message = null;
                    if (pendingMessage != null) {
                        String pendingState = pendingMessage.getToState();
                        if (nextState.equalsIgnoreCase(pendingState)) {
                            logger.debug((Object)("Message already exists for " + instanceName + " to transit " + resource.getResourceName() + "." + partition.getPartitionName() + " from " + currentState + " to " + nextState));
                        } else if (currentState.equalsIgnoreCase(pendingState)) {
                            logger.info((Object)("Message hasn't been removed for " + instanceName + " to transit " + resource.getResourceName() + "." + partition.getPartitionName() + " to " + pendingState + ", desiredState: " + desiredState));
                        } else {
                            logger.info((Object)("IdealState changed before state transition completes for " + resource.getResourceName() + "." + partition.getPartitionName() + " on " + instanceName + ", pendingState: " + pendingState + ", currentState: " + currentState + ", nextState: " + nextState));
                            Message cancellationMessage = currentStateOutput.getCancellationState(resourceName, partition, instanceName);
                            if (cache.getClusterConfig().isStateTransitionCancelEnabled() && cancellationMessage == null) {
                                logger.info((Object)("Send cancellation message of the state transition for " + resource.getResourceName() + "." + partition.getPartitionName() + " on " + instanceName + ", currentState: " + currentState + ", nextState: " + nextState));
                                message = this.createStateTransitionCancellationMessage(manager, resource, partition.getPartitionName(), instanceName, (String)sessionIdMap.get(instanceName), stateModelDef.getId(), pendingMessage.getFromState(), pendingMessage.getToState());
                            }
                        }
                    } else {
                        message = this.createStateTransitionMessage(manager, resource, partition.getPartitionName(), instanceName, currentState, nextState, (String)sessionIdMap.get(instanceName), stateModelDef.getId());
                    }
                    if (message == null) continue;
                    IdealState idealState = cache.getIdealState(resourceName);
                    if (idealState != null && idealState.getStateModelDefRef().equalsIgnoreCase("SchedulerTaskQueue") && idealState.getRecord().getMapField(partition.getPartitionName()) != null) {
                        message.getRecord().setMapField(Message.Attributes.INNER_MESSAGE.toString(), idealState.getRecord().getMapField(partition.getPartitionName()));
                    }
                    if ((timeout = this.getTimeOut(cache.getResourceConfig(resourceName), currentState, nextState, idealState, partition)) > 0) {
                        message.setExecutionTimeout(timeout);
                    }
                    message.getRecord().setSimpleField("ClusterEventName", event.getName());
                    if (!messageMap.containsKey(desiredState)) {
                        messageMap.put(desiredState, new ArrayList());
                    }
                    ((List)messageMap.get(desiredState)).add(message);
                }
                List<String> statesPriorityList = stateModelDef.getStatesPriorityList();
                for (String state : statesPriorityList) {
                    if (!messageMap.containsKey(state)) continue;
                    for (Message message : (List)messageMap.get(state)) {
                        output.addMessage(resourceName, partition, message);
                    }
                }
            }
        }
        event.addAttribute(AttributeName.MESSAGES_ALL.name(), output);
    }

    private Message createStateTransitionMessage(HelixManager manager, Resource resource, String partitionName, String instanceName, String currentState, String nextState, String sessionId, String stateModelDefName) {
        String uuid = UUID.randomUUID().toString();
        Message message = new Message(Message.MessageType.STATE_TRANSITION, uuid);
        message.setSrcName(manager.getInstanceName());
        message.setTgtName(instanceName);
        message.setMsgState(Message.MessageState.NEW);
        message.setPartitionName(partitionName);
        message.setResourceName(resource.getResourceName());
        message.setFromState(currentState);
        message.setToState(nextState);
        message.setTgtSessionId(sessionId);
        message.setSrcSessionId(manager.getSessionId());
        message.setStateModelDef(stateModelDefName);
        message.setStateModelFactoryName(resource.getStateModelFactoryname());
        message.setBucketSize(resource.getBucketSize());
        if (resource.getResourceGroupName() != null) {
            message.setResourceGroupName(resource.getResourceGroupName());
        }
        if (resource.getResourceTag() != null) {
            message.setResourceTag(resource.getResourceTag());
        }
        return message;
    }

    private Message createStateTransitionCancellationMessage(HelixManager manager, Resource resource, String partitionName, String instanceName, String sessionId, String stateModelDefName, String fromState, String nextState) {
        String uuid = UUID.randomUUID().toString();
        Message message = new Message(Message.MessageType.STATE_TRANSITION_CANCELLATION, uuid);
        message.setSrcName(manager.getInstanceName());
        message.setTgtName(instanceName);
        message.setMsgState(Message.MessageState.NEW);
        message.setPartitionName(partitionName);
        message.setResourceName(resource.getResourceName());
        message.setFromState(fromState);
        message.setToState(nextState);
        message.setTgtSessionId(sessionId);
        message.setSrcSessionId(manager.getSessionId());
        message.setStateModelDef(stateModelDefName);
        message.setStateModelFactoryName(resource.getStateModelFactoryname());
        message.setBucketSize(resource.getBucketSize());
        return message;
    }

    private int getTimeOut(ResourceConfig resourceConfig, String currentState, String nextState, IdealState idealState, Partition partition) {
        int timeout = -1;
        if (resourceConfig != null) {
            StateTransitionTimeoutConfig stateTransitionTimeoutConfig = resourceConfig.getStateTransitionTimeoutConfig();
            int n = timeout = stateTransitionTimeoutConfig != null ? stateTransitionTimeoutConfig.getStateTransitionTimeout(currentState, nextState) : -1;
        }
        if (timeout <= 0) {
            String timeOutStr = null;
            if (idealState != null) {
                String stateTransition = currentState + "-" + nextState + "_" + (Object)((Object)Message.Attributes.TIMEOUT);
                timeOutStr = idealState.getRecord().getSimpleField(stateTransition);
                if (timeOutStr == null && idealState.getStateModelDefRef().equalsIgnoreCase("SchedulerTaskQueue") && idealState.getRecord().getMapField(partition.getPartitionName()) != null) {
                    timeOutStr = idealState.getRecord().getMapField(partition.getPartitionName()).get(Message.Attributes.TIMEOUT.toString());
                }
            }
            if (timeOutStr != null) {
                try {
                    timeout = Integer.parseInt(timeOutStr);
                }
                catch (Exception e) {
                    logger.error((Object)"", (Throwable)e);
                }
            }
        }
        return timeout;
    }
}

