/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.helix.ZNRecord;
import org.apache.helix.controller.rebalancer.AbstractRebalancer;
import org.apache.helix.controller.rebalancer.util.RebalanceScheduler;
import org.apache.helix.controller.stages.ClusterDataCache;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.Partition;
import org.apache.helix.model.Resource;
import org.apache.helix.model.ResourceAssignment;
import org.apache.helix.model.StateModelDefinition;
import org.apache.log4j.Logger;

public class DelayedAutoRebalancer
extends AbstractRebalancer {
    private static final Logger LOG = Logger.getLogger(DelayedAutoRebalancer.class);
    private static RebalanceScheduler _scheduledRebalancer = new RebalanceScheduler();

    @Override
    public IdealState computeNewIdealState(String resourceName, IdealState currentIdealState, CurrentStateOutput currentStateOutput, ClusterDataCache clusterData) {
        ZNRecord newIdealMapping;
        Set<String> allNodes;
        Set<String> liveNodes;
        ArrayList<String> partitions = new ArrayList<String>(currentIdealState.getPartitionSet());
        if (partitions.size() == 0) {
            LOG.info((Object)("Partition count is 0 for resource " + resourceName + ", stop calculate ideal mapping for the resource."));
            return this.generateNewIdealState(resourceName, currentIdealState, this.emptyMapping(currentIdealState));
        }
        String instanceTag = currentIdealState.getInstanceGroupTag();
        if (instanceTag != null) {
            liveNodes = clusterData.getEnabledLiveInstancesWithTag(instanceTag);
            allNodes = clusterData.getInstancesWithTag(instanceTag);
            if (!liveNodes.isEmpty() && LOG.isInfoEnabled()) {
                LOG.info((Object)String.format("Found the following participants with tag %s for %s: %s", currentIdealState.getInstanceGroupTag(), resourceName, Arrays.toString(liveNodes.toArray())));
            }
        } else {
            liveNodes = clusterData.getEnabledLiveInstances();
            allNodes = clusterData.getEnabledInstances();
        }
        ClusterConfig clusterConfig = clusterData.getClusterConfig();
        long delayTime = this.getRebalanceDelay(currentIdealState, clusterConfig);
        Set<String> activeNodes = this.getActiveInstances(currentIdealState, allNodes, liveNodes, clusterData.getInstanceOfflineTimeMap(), delayTime, clusterConfig);
        this.setRebalanceScheduler(currentIdealState, activeNodes, clusterData.getInstanceOfflineTimeMap(), delayTime, clusterConfig);
        if (allNodes.isEmpty() || activeNodes.isEmpty()) {
            LOG.error((Object)String.format("No instances or active instances available for resource %s, allNodes: %s, liveNodes: %s, activeInstances: %s", resourceName, Arrays.toString(allNodes.toArray()), Arrays.toString(liveNodes.toArray()), Arrays.toString(activeNodes.toArray())));
            return this.generateNewIdealState(resourceName, currentIdealState, this.emptyMapping(currentIdealState));
        }
        StateModelDefinition stateModelDef = clusterData.getStateModelDef(currentIdealState.getStateModelDefRef());
        int replicaCount = this.getReplicaCount(currentIdealState, activeNodes);
        if (replicaCount == 0) {
            LOG.error((Object)("Replica count is 0 for resource " + resourceName + ", stop calculate ideal mapping for the resource."));
            return this.generateNewIdealState(resourceName, currentIdealState, this.emptyMapping(currentIdealState));
        }
        LinkedHashMap<String, Integer> stateCountMap = StateModelDefinition.getStateCountMap(stateModelDef, activeNodes.size(), replicaCount);
        Map<String, Map<String, String>> currentMapping = this.currentMapping(currentStateOutput, resourceName, partitions, stateCountMap);
        int maxPartition = currentIdealState.getMaxPartitionsPerInstance();
        this._rebalanceStrategy = this.getRebalanceStrategy(currentIdealState.getRebalanceStrategy(), partitions, resourceName, stateCountMap, maxPartition);
        ArrayList<String> allNodeList = new ArrayList<String>(allNodes);
        ArrayList<String> liveNodeList = new ArrayList<String>(liveNodes);
        Collections.sort(allNodeList);
        Collections.sort(liveNodeList);
        ZNRecord finalMapping = newIdealMapping = this._rebalanceStrategy.computePartitionAssignment(allNodeList, liveNodeList, currentMapping, clusterData);
        if (!this.isDelayRebalanceDisabled(currentIdealState, clusterConfig)) {
            ArrayList<String> activeNodeList = new ArrayList<String>(activeNodes);
            Collections.sort(activeNodeList);
            int minActiveReplicas = this.getMinActiveReplica(currentIdealState, replicaCount);
            ZNRecord newActiveMapping = this._rebalanceStrategy.computePartitionAssignment(allNodeList, activeNodeList, currentMapping, clusterData);
            finalMapping = this.getFinalDelayedMapping(currentIdealState, newIdealMapping, newActiveMapping, liveNodes, replicaCount, minActiveReplicas);
            LOG.debug((Object)("newActiveMapping: " + newActiveMapping));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("currentMapping: " + currentMapping));
            LOG.debug((Object)("stateCountMap: " + stateCountMap));
            LOG.debug((Object)("liveNodes: " + liveNodes));
            LOG.debug((Object)("allNodes: " + allNodes));
            LOG.debug((Object)("maxPartition: " + maxPartition));
            LOG.debug((Object)("newIdealMapping: " + newIdealMapping));
            LOG.debug((Object)("finalMapping: " + finalMapping));
        }
        return this.generateNewIdealState(resourceName, currentIdealState, finalMapping);
    }

    private IdealState generateNewIdealState(String resourceName, IdealState currentIdealState, ZNRecord newMapping) {
        IdealState newIdealState = new IdealState(resourceName);
        newIdealState.getRecord().setSimpleFields(currentIdealState.getRecord().getSimpleFields());
        newIdealState.setRebalanceMode(currentIdealState.getRebalanceMode());
        newIdealState.getRecord().setListFields(newMapping.getListFields());
        return newIdealState;
    }

    private Set<String> getActiveInstances(IdealState idealState, Set<String> allNodes, Set<String> liveNodes, Map<String, Long> instanceOfflineTimeMap, long delayTime, ClusterConfig clusterConfig) {
        HashSet<String> activeInstances = new HashSet<String>(liveNodes);
        if (this.isDelayRebalanceDisabled(idealState, clusterConfig)) {
            return activeInstances;
        }
        HashSet<String> offlineInstances = new HashSet<String>(allNodes);
        offlineInstances.removeAll(liveNodes);
        long currentTime = System.currentTimeMillis();
        for (String ins : offlineInstances) {
            Long offlineTime = instanceOfflineTimeMap.get(ins);
            if (offlineTime == null || offlineTime <= 0L || delayTime <= 0L || offlineTime + delayTime <= currentTime) continue;
            activeInstances.add(ins);
        }
        return activeInstances;
    }

    private void setRebalanceScheduler(IdealState idealState, Set<String> activeInstances, Map<String, Long> instanceOfflineTimeMap, long delayTime, ClusterConfig clusterConfig) {
        String resourceName = idealState.getResourceName();
        if (this.isDelayRebalanceDisabled(idealState, clusterConfig)) {
            _scheduledRebalancer.removeScheduledRebalance(resourceName);
            return;
        }
        long nextRebalanceTime = Long.MAX_VALUE;
        for (String ins : activeInstances) {
            long rebalanceTime;
            Long offlineTime = instanceOfflineTimeMap.get(ins);
            if (offlineTime == null || offlineTime <= 0L || offlineTime + delayTime >= nextRebalanceTime || (rebalanceTime = offlineTime + delayTime) >= nextRebalanceTime) continue;
            nextRebalanceTime = rebalanceTime;
        }
        if (nextRebalanceTime == Long.MAX_VALUE) {
            long startTime = _scheduledRebalancer.removeScheduledRebalance(resourceName);
            LOG.debug((Object)String.format("Remove exist rebalance timer for resource %s at %d\n", resourceName, startTime));
        } else {
            _scheduledRebalancer.scheduleRebalance(this._manager, resourceName, nextRebalanceTime);
            LOG.debug((Object)String.format("Set next rebalance time for resource %s at time %d\n", resourceName, nextRebalanceTime));
        }
    }

    private long getRebalanceDelay(IdealState idealState, ClusterConfig clusterConfig) {
        long delayTime = idealState.getRebalanceDelay();
        if (delayTime < 0L) {
            delayTime = clusterConfig.getRebalanceDelayTime();
        }
        return delayTime;
    }

    private boolean isDelayRebalanceDisabled(IdealState idealState, ClusterConfig clusterConfig) {
        long delayTime = this.getRebalanceDelay(idealState, clusterConfig);
        return delayTime < 0L || idealState.isDelayRebalanceDisabled() || clusterConfig.isDelayRebalaceDisabled();
    }

    private ZNRecord getFinalDelayedMapping(IdealState idealState, ZNRecord newIdealMapping, ZNRecord newActiveMapping, Set<String> liveInstances, int numReplica, int minActiveReplica) {
        if (minActiveReplica >= numReplica) {
            return newIdealMapping;
        }
        ZNRecord finalMapping = new ZNRecord(idealState.getResourceName());
        for (String partition : idealState.getPartitionSet()) {
            List<String> idealList = newIdealMapping.getListField(partition);
            List<String> activeList = newActiveMapping.getListField(partition);
            ArrayList<String> liveList = new ArrayList<String>();
            int activeReplica = 0;
            for (String ins : activeList) {
                if (!liveInstances.contains(ins)) continue;
                ++activeReplica;
                liveList.add(ins);
            }
            if (activeReplica >= minActiveReplica) {
                finalMapping.setListField(partition, activeList);
                continue;
            }
            ArrayList<String> candidates = new ArrayList<String>(idealList);
            candidates.removeAll(activeList);
            for (String liveIns : candidates) {
                liveList.add(liveIns);
                if (liveList.size() < minActiveReplica) continue;
                break;
            }
            finalMapping.setListField(partition, liveList);
        }
        return finalMapping;
    }

    private ZNRecord emptyMapping(IdealState idealState) {
        ZNRecord emptyMapping = new ZNRecord(idealState.getResourceName());
        for (String partition : idealState.getPartitionSet()) {
            emptyMapping.setListField(partition, new ArrayList<String>());
        }
        return emptyMapping;
    }

    @Override
    public ResourceAssignment computeBestPossiblePartitionState(ClusterDataCache cache, IdealState idealState, Resource resource, CurrentStateOutput currentStateOutput) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Processing resource:" + resource.getResourceName()));
        }
        Set<String> allNodes = cache.getEnabledInstances();
        Set<String> liveNodes = cache.getEnabledLiveInstances();
        Set<String> offlineNodes = cache.getAllInstances();
        offlineNodes.removeAll(cache.getLiveInstances().keySet());
        ClusterConfig clusterConfig = cache.getClusterConfig();
        long delayTime = this.getRebalanceDelay(idealState, clusterConfig);
        Set<String> activeNodes = this.getActiveInstances(idealState, allNodes, liveNodes, cache.getInstanceOfflineTimeMap(), delayTime, clusterConfig);
        String stateModelDefName = idealState.getStateModelDefRef();
        StateModelDefinition stateModelDef = cache.getStateModelDef(stateModelDefName);
        ResourceAssignment partitionMapping = new ResourceAssignment(resource.getResourceName());
        for (Partition partition : resource.getPartitions()) {
            Map<String, String> currentStateMap = currentStateOutput.getCurrentStateMap(resource.getResourceName(), partition);
            Set<String> disabledInstancesForPartition = cache.getDisabledInstancesForPartition(resource.getResourceName(), partition.toString());
            List<String> preferenceList = DelayedAutoRebalancer.getPreferenceList(partition, idealState, activeNodes);
            Map<String, String> bestStateForPartition = this.computeAutoBestStateForPartition(cache, stateModelDef, preferenceList, currentStateMap, disabledInstancesForPartition, idealState.isEnabled());
            if (preferenceList == null) {
                LOG.info((Object)String.format("No preferenceList defined for partition %s, resource %s, skip computing best possible mapping!", partition.getPartitionName(), idealState.getResourceName()));
                continue;
            }
            for (String ins : preferenceList) {
                if (!offlineNodes.contains(ins) || bestStateForPartition.containsKey(ins)) continue;
                bestStateForPartition.put(ins, stateModelDef.getInitialState());
            }
            partitionMapping.addReplicaMap(partition, bestStateForPartition);
        }
        return partitionMapping;
    }

    private int getReplicaCount(IdealState idealState, Set<String> eligibleInstances) {
        String replicaStr = idealState.getReplicas();
        int replica = 0;
        try {
            replica = Integer.parseInt(replicaStr);
        }
        catch (NumberFormatException ex) {
            if (replicaStr.equalsIgnoreCase(IdealState.IdealStateConstants.ANY_LIVEINSTANCE.name())) {
                replica = eligibleInstances.size();
            }
            LOG.error((Object)("Can not determine the replica count for resource " + idealState.getResourceName() + ", set to 0."));
        }
        return replica;
    }

    private int getMinActiveReplica(IdealState idealState, int replicaCount) {
        int minActiveReplicas = idealState.getMinActiveReplicas();
        if (minActiveReplicas < 0) {
            minActiveReplicas = replicaCount;
        }
        return minActiveReplicas;
    }
}

