/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics.graphite;

import com.codahale.metrics.graphite.GraphiteSender;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import org.apache.gobblin.metrics.graphite.GraphiteConnectionType;

public class GraphitePusher
implements Closeable {
    private GraphiteSender graphiteSender;
    private final Closer closer = Closer.create();

    public GraphitePusher(String hostname, int port, GraphiteConnectionType connectionType) throws IOException {
        this.graphiteSender = (GraphiteSender)this.closer.register((Closeable)connectionType.createConnection(hostname, port));
        if (this.graphiteSender != null && !this.graphiteSender.isConnected()) {
            this.graphiteSender.connect();
        }
    }

    public void push(String name, String value, long timestamp) throws IOException {
        this.graphiteSender.send(name, value, timestamp);
    }

    public void flush() throws IOException {
        this.graphiteSender.flush();
    }

    @Override
    public void close() throws IOException {
        this.closer.close();
    }
}

