/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.docgen;

import com.linkedin.data.template.RecordTemplate;
import com.linkedin.restli.docgen.ResourceSchemaVisitior;
import com.linkedin.restli.restspec.ActionSchema;
import com.linkedin.restli.restspec.ActionsSetSchema;
import com.linkedin.restli.restspec.AssociationSchema;
import com.linkedin.restli.restspec.CollectionSchema;
import com.linkedin.restli.restspec.EntitySchema;
import com.linkedin.restli.restspec.FinderSchema;
import com.linkedin.restli.restspec.ParameterSchema;
import com.linkedin.restli.restspec.ResourceSchema;
import com.linkedin.restli.restspec.RestMethodSchema;
import com.linkedin.restli.restspec.SimpleSchema;
import com.linkedin.restli.server.ResourceLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingResourceSchemaVisitor
implements ResourceSchemaVisitior {
    private final Logger _logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void visitAction(ResourceSchemaVisitior.VisitContext visitContext, RecordTemplate parentResource, ResourceLevel resourceLevel, ActionSchema actionSchema) {
        this._logger.info("Visiting action: " + actionSchema.getName());
        this._logger.info("resource schema: " + visitContext.getResourcePath());
        this._logger.info("resource level: " + resourceLevel);
    }

    @Override
    public void visitFinder(ResourceSchemaVisitior.VisitContext visitContext, RecordTemplate parentResource, FinderSchema finderSchema) {
        this._logger.info("Visiting finder: " + finderSchema.getName());
        this._logger.info("resourcePath: " + visitContext.getResourcePath());
    }

    @Override
    public void visitParameter(ResourceSchemaVisitior.VisitContext visitContext, RecordTemplate parentResource, Object parentMethodSchema, ParameterSchema parameterSchema) {
        this._logger.info("Visiting parameter: " + parameterSchema.getName());
        this._logger.info("resourcePath: " + visitContext.getResourcePath());
    }

    @Override
    public void visitRestMethod(ResourceSchemaVisitior.VisitContext visitContext, RecordTemplate parentResource, RestMethodSchema restMethodSchema) {
        this._logger.info("Visiting restMethod: " + restMethodSchema.getMethod());
        this._logger.info("resourcePath: " + visitContext.getResourcePath());
    }

    @Override
    public void visitActionSetResource(ResourceSchemaVisitior.VisitContext visitContext, ActionsSetSchema actionSet) {
        this._logger.info("Visiting actionSet for resource: " + visitContext.getResourcePath());
    }

    @Override
    public void visitAssociationResource(ResourceSchemaVisitior.VisitContext visitContext, AssociationSchema associationSchema) {
        this._logger.info("Visiting association for resource: " + visitContext.getResourcePath());
    }

    @Override
    public void visitCollectionResource(ResourceSchemaVisitior.VisitContext visitContext, CollectionSchema collectionSchema) {
        this._logger.info("Visiting collection for resource: " + visitContext.getResourcePath());
    }

    @Override
    public void visitSimpleResource(ResourceSchemaVisitior.VisitContext visitContext, SimpleSchema collectionSchema) {
        this._logger.info("Visiting simple for resource: " + visitContext.getResourcePath());
    }

    @Override
    public void visitEntityResource(ResourceSchemaVisitior.VisitContext visitContext, EntitySchema entitySchema) {
        this._logger.info("Visiting entity for resource: " + visitContext.getResourcePath());
    }

    @Override
    public void visitResourceSchema(ResourceSchemaVisitior.VisitContext visitContext, ResourceSchema resourceSchema) {
        this._logger.info("Visiting resource: " + visitContext.getResourcePath());
    }
}

