/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common;

public class Version
implements Comparable<Version> {
    private final int _major;
    private final int _minor;
    private final int _patch;
    private static final String VERSION_NUMBER_SEPARATOR = "\\.";
    private static final String PRE_RELEASE_VERSION_SEPARATOR = "\\-";

    public Version(String version) {
        String[] parts = version.split(VERSION_NUMBER_SEPARATOR);
        if (parts.length == 3) {
            try {
                this._major = Integer.parseInt(parts[0]);
                this._minor = Integer.parseInt(parts[1]);
                this._patch = Integer.parseInt(parts[2].split(PRE_RELEASE_VERSION_SEPARATOR)[0]);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Illegal version " + version + " specified.");
            }
        } else {
            throw new IllegalArgumentException("Illegal version " + version + " specified.");
        }
    }

    public Version(int major, int minor, int patch) {
        this._major = major;
        this._minor = minor;
        this._patch = patch;
    }

    public int getMajor() {
        return this._major;
    }

    public int getMinor() {
        return this._minor;
    }

    public int getPatch() {
        return this._patch;
    }

    public int hashCode() {
        int result = this._major;
        result = 31 * result + this._minor;
        result = 31 * result + this._patch;
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Version)) {
            return false;
        }
        Version other = (Version)obj;
        return this._major == other._major && this._minor == other._minor && this._patch == other._patch;
    }

    public String toString() {
        return this._major + "." + this._minor + "." + this._patch;
    }

    @Override
    public int compareTo(Version o) {
        if (this._major == o._major) {
            if (this._minor == o._minor) {
                if (this._patch == o._patch) {
                    return 0;
                }
                return this._patch > o._patch ? 1 : -1;
            }
            return this._minor > o._minor ? 1 : -1;
        }
        return this._major > o._major ? 1 : -1;
    }
}

