/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.trash;

import azkaban.jobExecutor.AbstractJob;
import azkaban.utils.Props;
import java.io.IOException;
import java.util.Properties;
import org.apache.gobblin.data.management.trash.Trash;
import org.apache.gobblin.data.management.trash.TrashFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;

public class TrashCollectorJob
extends AbstractJob
implements Tool {
    private Configuration conf;
    private Trash trash;

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new TrashCollectorJob(TrashCollectorJob.class.getName()), (String[])args);
    }

    public TrashCollectorJob(String id) {
        super(id, Logger.getLogger(TrashCollectorJob.class));
    }

    public TrashCollectorJob(String id, Props props) throws IOException {
        super(id, Logger.getLogger(TrashCollectorJob.class));
        this.conf = new Configuration();
        this.trash = this.createTrash(props);
    }

    Trash createTrash(Props props) throws IOException {
        return TrashFactory.createTrash((FileSystem)FileSystem.get((Configuration)this.getConf()), (Properties)props.toProperties());
    }

    public static boolean moveToTrash(FileSystem fs, Path path, Props props) throws IOException {
        return TrashFactory.createTrash((FileSystem)fs, (Properties)props.toProperties()).moveToTrash(path);
    }

    public int run(String[] args) throws Exception {
        if (args.length < 1) {
            System.out.println("Must provide properties file as first argument.");
            return 1;
        }
        Props props = new Props(null, args[0]);
        new TrashCollectorJob(TrashCollectorJob.class.getName(), props).run();
        return 0;
    }

    public void setConf(Configuration configuration) {
        this.conf = configuration;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void run() throws Exception {
        if (this.trash != null) {
            this.trash.createTrashSnapshot();
            this.trash.purgeTrashSnapshots();
        }
    }
}

