/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.retention;

import azkaban.jobExecutor.AbstractJob;
import com.google.common.base.Optional;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.data.management.conversion.hive.dataset.ConvertibleHiveDataset;
import org.apache.gobblin.data.management.conversion.hive.dataset.ConvertibleHiveDatasetFinder;
import org.apache.gobblin.data.management.conversion.hive.validation.ValidationJob;
import org.apache.gobblin.data.management.copy.hive.HiveUtils;
import org.apache.gobblin.instrumented.Instrumented;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.event.EventSubmitter;
import org.apache.gobblin.util.AutoReturnableObject;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.log4j.Logger;

public class Avro2OrcStaleDatasetCleaner
extends AbstractJob {
    private static final Logger log = Logger.getLogger(ValidationJob.class);
    private static final String HIVE_PARTITION_DELETION_GRACE_TIME_IN_DAYS = "hive.partition.deletion.graceTime.inDays";
    private static final String DEFAULT_HIVE_PARTITION_DELETION_GRACE_TIME_IN_DAYS = "2";
    private final MetricContext metricContext;
    private final EventSubmitter eventSubmitter;
    private final ConvertibleHiveDatasetFinder datasetFinder;
    private static final String HIVE_DATASET_CONFIG_AVRO_PREFIX = "hive.conversion.avro";
    private final FileSystem fs;
    private final long graceTimeInMillis;

    public Avro2OrcStaleDatasetCleaner(String jobId, Properties props) throws IOException {
        super(jobId, log);
        props.setProperty("hive.dataset.configPrefix", HIVE_DATASET_CONFIG_AVRO_PREFIX);
        this.graceTimeInMillis = TimeUnit.DAYS.toMillis(Long.parseLong(props.getProperty(HIVE_PARTITION_DELETION_GRACE_TIME_IN_DAYS, DEFAULT_HIVE_PARTITION_DELETION_GRACE_TIME_IN_DAYS)));
        Config config = ConfigFactory.parseProperties((Properties)props);
        this.fs = FileSystem.newInstance((Configuration)new Configuration());
        this.metricContext = Instrumented.getMetricContext((State)ConfigUtils.configToState((Config)config), ValidationJob.class);
        this.eventSubmitter = new EventSubmitter.Builder(this.metricContext, "gobblin.hive.conversion").build();
        this.datasetFinder = new ConvertibleHiveDatasetFinder(this.fs, props, this.eventSubmitter);
    }

    public void run() throws Exception {
        Iterator iterator = this.datasetFinder.getDatasetsIterator();
        while (iterator.hasNext()) {
            ConvertibleHiveDataset hiveDataset = (ConvertibleHiveDataset)iterator.next();
            AutoReturnableObject client = hiveDataset.getClientPool().getClient();
            Throwable throwable = null;
            try {
                HashSet sourcePartitions = new HashSet(HiveUtils.getPartitions((IMetaStoreClient)((IMetaStoreClient)client.get()), (Table)hiveDataset.getTable(), (Optional)Optional.absent()));
                sourcePartitions.parallelStream().filter(partition -> Avro2OrcStaleDatasetCleaner.isUnixTimeStamp(partition.getDataLocation().getName())).forEach(partition -> Arrays.stream(this.listFiles(partition.getDataLocation().getParent())).filter(fileStatus -> !fileStatus.getPath().toString().equalsIgnoreCase(partition.getDataLocation().toString())).forEach(fileStatus -> this.deletePath((FileStatus)fileStatus, this.graceTimeInMillis, true)));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (client == null) continue;
                if (throwable != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                client.close();
            }
        }
    }

    private FileStatus[] listFiles(Path path) {
        try {
            return this.fs.listStatus(path);
        }
        catch (IOException e) {
            log.error((Object)("Unalbe to list files for directory " + path), (Throwable)e);
            return new FileStatus[0];
        }
    }

    private void deletePath(FileStatus fileStatus, long graceTimeInMillis, boolean recursively) {
        long modificationTime = fileStatus.getModificationTime();
        long currentTime = System.currentTimeMillis();
        if (currentTime - modificationTime < 0L) {
            log.error((Object)("Modification time cannot be greater than current time: " + fileStatus.getPath()));
            return;
        }
        if (currentTime - modificationTime < graceTimeInMillis) {
            log.info((Object)("Modification time is still within grace time for deletion: " + fileStatus.getPath()));
            return;
        }
        try {
            this.fs.delete(fileStatus.getPath(), recursively);
            log.info((Object)("Deleted path " + fileStatus.getPath()));
        }
        catch (IOException e) {
            log.error((Object)("Unable to delete directory " + fileStatus.getPath()), (Throwable)e);
        }
    }

    private static boolean isUnixTimeStamp(String timeStamp) {
        int TIME_STAMP_LENGTH = 13;
        if (timeStamp.length() != TIME_STAMP_LENGTH) {
            return false;
        }
        try {
            Long.parseLong(timeStamp);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

