/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.transform.filter.request;

import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.transform.filter.request.MaskOperation;
import com.linkedin.data.transform.filter.request.MaskTree;
import java.util.Arrays;
import java.util.Collection;

public class MaskCreator {
    public static MaskTree createPositiveMask(PathSpec ... paths) {
        return MaskCreator.createPositiveMask(Arrays.asList(paths));
    }

    public static MaskTree createPositiveMask(Collection<PathSpec> paths) {
        return MaskCreator.createMaskTree(paths, MaskOperation.POSITIVE_MASK_OP);
    }

    public static MaskTree createNegativeMask(PathSpec ... paths) {
        return MaskCreator.createNegativeMask(Arrays.asList(paths));
    }

    public static MaskTree createNegativeMask(Collection<PathSpec> paths) {
        return MaskCreator.createMaskTree(paths, MaskOperation.NEGATIVE_MASK_OP);
    }

    private static MaskTree createMaskTree(Collection<PathSpec> paths, MaskOperation op) {
        MaskTree maskTree = new MaskTree();
        for (PathSpec path : paths) {
            maskTree.addOperation(path, op);
        }
        return maskTree;
    }
}

