/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.transform.filter;

import com.linkedin.data.DataMap;
import com.linkedin.data.transform.filter.FilterConstants;
import com.linkedin.data.transform.filter.FilterUtil;
import com.linkedin.data.transform.filter.NodeMode;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;

public class DefaultNodeModeCalculator {
    private IdentityHashMap<DataMap, NodeMode> _defaultNodeModes = new IdentityHashMap();

    public NodeMode getDefaultNodeMode(DataMap opNode) {
        assert (opNode != null);
        NodeMode defaulNodeMode = this._defaultNodeModes.get(opNode);
        if (defaulNodeMode == null) {
            Object wldcrd = opNode.get((Object)"$*");
            if (wldcrd != null) {
                if (wldcrd.equals(FilterConstants.NEGATIVE)) {
                    defaulNodeMode = NodeMode.HIDE_HIGH;
                } else if (FilterUtil.isMarkedAsMergedWith1(opNode)) {
                    defaulNodeMode = NodeMode.SHOW_HIGH;
                }
            }
            Iterator it = opNode.entrySet().iterator();
            while (it.hasNext() && defaulNodeMode == null) {
                NodeMode childNodeMode;
                Map.Entry entry = (Map.Entry)it.next();
                Object o = entry.getValue();
                if (((String)entry.getKey()).equals("$start") || ((String)entry.getKey()).equals("$count")) {
                    defaulNodeMode = NodeMode.HIDE_LOW;
                    continue;
                }
                if (o instanceof Integer && (Integer)o == 1) {
                    defaulNodeMode = NodeMode.HIDE_LOW;
                    continue;
                }
                if (o.getClass() != DataMap.class || !(childNodeMode = this.getDefaultNodeMode((DataMap)o)).equals((Object)NodeMode.HIDE_LOW) && !childNodeMode.equals((Object)NodeMode.SHOW_HIGH)) continue;
                defaulNodeMode = NodeMode.HIDE_LOW;
            }
            if (defaulNodeMode == null) {
                defaulNodeMode = NodeMode.SHOW_LOW;
            }
        }
        this._defaultNodeModes.put(opNode, defaulNodeMode);
        return defaulNodeMode;
    }
}

