/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.transform;

import com.linkedin.data.DataMap;
import com.linkedin.data.Null;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.transform.filter.CopyFilter;
import com.linkedin.data.transform.filter.request.MaskTree;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ProjectionUtil {
    public static boolean isPathPresent(MaskTree filter, PathSpec path) {
        return !ProjectionUtil.getPresentPaths(filter, Collections.singleton(path)).isEmpty();
    }

    public static Set<PathSpec> getPresentPaths(MaskTree filter, Set<PathSpec> paths) {
        if (filter == null) {
            return paths;
        }
        DataMap filterMap = filter.getDataMap();
        if (filter.getDataMap().isEmpty()) {
            return Collections.emptySet();
        }
        DataMap pathSpecMap = ProjectionUtil.createPathSpecMap(paths);
        DataMap filteredPathSpecs = (DataMap)new PathSpecFilter().filter(pathSpecMap, filterMap);
        return ProjectionUtil.validate(filteredPathSpecs, paths);
    }

    private static DataMap createPathSpecMap(Set<PathSpec> paths) {
        DataMap pathSpecMap = new DataMap();
        for (PathSpec p : paths) {
            List components = p.getPathComponents();
            DataMap currentMap = pathSpecMap;
            for (int i = 0; i < components.size(); ++i) {
                String currentComponent = (String)components.get(i);
                Object currentValue = currentMap.get((Object)currentComponent);
                if (i < components.size() - 1) {
                    if (currentValue instanceof DataMap) {
                        DataMap valueMap;
                        currentMap = valueMap = (DataMap)currentValue;
                        continue;
                    }
                    DataMap newMap = new DataMap();
                    currentMap.put((Object)currentComponent, (Object)newMap);
                    currentMap = newMap;
                    continue;
                }
                if (currentValue != null) continue;
                currentMap.put((Object)currentComponent, (Object)Null.getInstance());
            }
        }
        return pathSpecMap;
    }

    private static Set<PathSpec> validate(DataMap filteredPathSpecs, Set<PathSpec> paths) {
        HashSet<PathSpec> result = new HashSet<PathSpec>();
        for (PathSpec p : paths) {
            List components = p.getPathComponents();
            DataMap currentMap = filteredPathSpecs;
            boolean isPresent = true;
            for (int i = 0; i < components.size(); ++i) {
                DataMap valueMap;
                String currentComponent = (String)components.get(i);
                Object currentValue = currentMap.get((Object)currentComponent);
                if (!(currentValue instanceof DataMap)) {
                    isPresent = currentMap.containsKey((Object)currentComponent);
                    break;
                }
                currentMap = valueMap = (DataMap)currentValue;
            }
            if (!isPresent) continue;
            result.add(p);
        }
        return result;
    }

    private static class PathSpecFilter
    extends CopyFilter {
        private PathSpecFilter() {
        }

        @Override
        protected Object onError(Object field, String format, Object ... args) {
            return null;
        }
    }
}

