/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer;

import java.io.Closeable;
import java.util.Collections;
import java.util.Map;
import org.apache.gobblin.source.extractor.CheckpointableWatermark;

public interface WatermarkManager
extends Closeable {
    public void start();

    public CommitStatus getCommitStatus();

    public RetrievalStatus getRetrievalStatus();

    public static class CommitStatus {
        private long lastWatermarkCommitAttemptTimestampMillis = 0L;
        private long lastWatermarkCommitSuccessTimestampMillis = 0L;
        private long lastWatermarkCommitFailureTimestampMillis = 0L;
        private Map<String, CheckpointableWatermark> lastCommittedWatermarks = Collections.EMPTY_MAP;
        private Exception lastCommitException = null;
        private Map<String, CheckpointableWatermark> lastFailedWatermarks = Collections.EMPTY_MAP;

        synchronized void onAttempt() {
            this.lastWatermarkCommitAttemptTimestampMillis = System.currentTimeMillis();
        }

        synchronized void onSuccess(Map<String, CheckpointableWatermark> watermarksToCommit) {
            this.lastWatermarkCommitSuccessTimestampMillis = System.currentTimeMillis();
            this.lastCommittedWatermarks = watermarksToCommit;
        }

        synchronized void onFailure(Exception commitException, Map<String, CheckpointableWatermark> watermarksToCommit) {
            this.lastWatermarkCommitFailureTimestampMillis = System.currentTimeMillis();
            this.lastCommitException = commitException;
            this.lastFailedWatermarks = watermarksToCommit;
        }

        public long getLastWatermarkCommitAttemptTimestampMillis() {
            return this.lastWatermarkCommitAttemptTimestampMillis;
        }

        public long getLastWatermarkCommitSuccessTimestampMillis() {
            return this.lastWatermarkCommitSuccessTimestampMillis;
        }

        public long getLastWatermarkCommitFailureTimestampMillis() {
            return this.lastWatermarkCommitFailureTimestampMillis;
        }

        public Map<String, CheckpointableWatermark> getLastCommittedWatermarks() {
            return this.lastCommittedWatermarks;
        }

        public Exception getLastCommitException() {
            return this.lastCommitException;
        }

        public Map<String, CheckpointableWatermark> getLastFailedWatermarks() {
            return this.lastFailedWatermarks;
        }

        public String toString() {
            return "WatermarkManager.CommitStatus(lastWatermarkCommitAttemptTimestampMillis=" + this.getLastWatermarkCommitAttemptTimestampMillis() + ", lastWatermarkCommitSuccessTimestampMillis=" + this.getLastWatermarkCommitSuccessTimestampMillis() + ", lastWatermarkCommitFailureTimestampMillis=" + this.getLastWatermarkCommitFailureTimestampMillis() + ", lastCommittedWatermarks=" + this.getLastCommittedWatermarks() + ", lastCommitException=" + this.getLastCommitException() + ", lastFailedWatermarks=" + this.getLastFailedWatermarks() + ")";
        }
    }

    public static class RetrievalStatus {
        private long lastWatermarkRetrievalAttemptTimestampMillis = 0L;
        private long lastWatermarkRetrievalSuccessTimestampMillis = 0L;
        private long lastWatermarkRetrievalFailureTimestampMillis = 0L;
        private Map<String, CheckpointableWatermark> lastRetrievedWatermarks = Collections.EMPTY_MAP;
        private Exception lastRetrievalException = null;

        synchronized void onAttempt() {
            this.lastWatermarkRetrievalAttemptTimestampMillis = System.currentTimeMillis();
        }

        synchronized void onSuccess(Map<String, CheckpointableWatermark> retrievedWatermarks) {
            this.lastWatermarkRetrievalSuccessTimestampMillis = System.currentTimeMillis();
            this.lastRetrievedWatermarks = retrievedWatermarks;
        }

        synchronized void onFailure(Exception retrievalException) {
            this.lastWatermarkRetrievalFailureTimestampMillis = System.currentTimeMillis();
            this.lastRetrievalException = retrievalException;
        }

        public long getLastWatermarkRetrievalAttemptTimestampMillis() {
            return this.lastWatermarkRetrievalAttemptTimestampMillis;
        }

        public long getLastWatermarkRetrievalSuccessTimestampMillis() {
            return this.lastWatermarkRetrievalSuccessTimestampMillis;
        }

        public long getLastWatermarkRetrievalFailureTimestampMillis() {
            return this.lastWatermarkRetrievalFailureTimestampMillis;
        }

        public Map<String, CheckpointableWatermark> getLastRetrievedWatermarks() {
            return this.lastRetrievedWatermarks;
        }

        public Exception getLastRetrievalException() {
            return this.lastRetrievalException;
        }

        public String toString() {
            return "WatermarkManager.RetrievalStatus(lastWatermarkRetrievalAttemptTimestampMillis=" + this.getLastWatermarkRetrievalAttemptTimestampMillis() + ", lastWatermarkRetrievalSuccessTimestampMillis=" + this.getLastWatermarkRetrievalSuccessTimestampMillis() + ", lastWatermarkRetrievalFailureTimestampMillis=" + this.getLastWatermarkRetrievalFailureTimestampMillis() + ", lastRetrievedWatermarks=" + this.getLastRetrievedWatermarks() + ", lastRetrievalException=" + this.getLastRetrievalException() + ")";
        }
    }
}

