/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.source.extractor.CheckpointableWatermark;
import org.apache.gobblin.util.ExecutorsUtils;
import org.apache.gobblin.writer.MultiWriterWatermarkTracker;
import org.apache.gobblin.writer.WatermarkAwareWriter;
import org.apache.gobblin.writer.WatermarkManager;
import org.apache.gobblin.writer.WatermarkStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiWriterWatermarkManager
implements WatermarkManager {
    private final Queue<WatermarkAwareWriter> _watermarkAwareWriters;
    private final WatermarkStorage _watermarkStorage;
    private final long _commitIntervalMillis;
    private final ScheduledExecutorService _watermarkCommitThreadPool;
    private final Logger _logger;
    private final WatermarkManager.RetrievalStatus _retrievalStatus;
    private final WatermarkManager.CommitStatus _commitStatus;
    @VisibleForTesting
    final Runnable _watermarkCommitter = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long startTime = System.nanoTime();
            Map<String, CheckpointableWatermark> watermarksToCommit = null;
            try {
                MultiWriterWatermarkManager.this._retrievalStatus.onAttempt();
                MultiWriterWatermarkTracker watermarkTracker = new MultiWriterWatermarkTracker();
                for (WatermarkAwareWriter writer : MultiWriterWatermarkManager.this._watermarkAwareWriters) {
                    Map<String, CheckpointableWatermark> writerWatermarks = writer.getCommittableWatermark();
                    MultiWriterWatermarkManager.this._logger.debug("Retrieved from writer {} : watermark {} ", (Object)writer.getClass().getName(), writerWatermarks);
                    watermarkTracker.committedWatermarks(writerWatermarks);
                }
                watermarksToCommit = watermarkTracker.getAllCommitableWatermarks();
                MultiWriterWatermarkManager.this._retrievalStatus.onSuccess(watermarksToCommit);
            }
            catch (Exception e) {
                MultiWriterWatermarkManager.this._retrievalStatus.onFailure(e);
                MultiWriterWatermarkManager.this._logger.error("Failed to get watermark", (Throwable)e);
            }
            1 e = this;
            synchronized (e) {
                if (watermarksToCommit != null && !watermarksToCommit.isEmpty()) {
                    try {
                        MultiWriterWatermarkManager.this._commitStatus.onAttempt();
                        MultiWriterWatermarkManager.this._logger.info("Will commit watermark {}", (Object)watermarksToCommit.toString());
                        MultiWriterWatermarkManager.this._watermarkStorage.commitWatermarks(watermarksToCommit.values());
                        MultiWriterWatermarkManager.this._commitStatus.onSuccess(watermarksToCommit);
                    }
                    catch (Exception e2) {
                        MultiWriterWatermarkManager.this._commitStatus.onFailure(e2, watermarksToCommit);
                        MultiWriterWatermarkManager.this._logger.error("Failed to write watermark", (Throwable)e2);
                    }
                } else {
                    MultiWriterWatermarkManager.this._logger.info("Nothing to commit");
                }
            }
            long duration = (System.nanoTime() - startTime) / 1000000L;
            MultiWriterWatermarkManager.this._logger.info("Duration of run {} milliseconds", (Object)duration);
        }
    };

    public MultiWriterWatermarkManager(WatermarkStorage storage, long commitIntervalMillis, Optional<Logger> logger) {
        Preconditions.checkArgument((storage != null ? 1 : 0) != 0, (Object)"WatermarkStorage cannot be null");
        this._watermarkAwareWriters = new ConcurrentLinkedQueue<WatermarkAwareWriter>();
        this._watermarkStorage = storage;
        this._commitIntervalMillis = commitIntervalMillis;
        this._logger = (Logger)logger.or((Object)LoggerFactory.getLogger(MultiWriterWatermarkManager.class));
        this._watermarkCommitThreadPool = new ScheduledThreadPoolExecutor(1, ExecutorsUtils.newThreadFactory(logger, (Optional)Optional.of((Object)"WatermarkManager-%d")));
        this._retrievalStatus = new WatermarkManager.RetrievalStatus();
        this._commitStatus = new WatermarkManager.CommitStatus();
    }

    public void registerWriter(WatermarkAwareWriter dataWriter) {
        this._watermarkAwareWriters.add(dataWriter);
        this._logger.info("Registered a watermark aware writer {}", (Object)dataWriter.getClass().getName());
    }

    @Override
    public void start() {
        this._watermarkCommitThreadPool.scheduleWithFixedDelay(this._watermarkCommitter, 0L, this._commitIntervalMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public void close() throws IOException {
        this._logger.info("Watermark committer closing");
        this._watermarkCommitThreadPool.shutdown();
        try {
            long startTime = System.nanoTime();
            this._watermarkCommitThreadPool.awaitTermination(1000L, TimeUnit.MILLISECONDS);
            long duration = (System.nanoTime() - startTime) / 1000000L;
            this._logger.info("Duration of termination wait was {} milliseconds", (Object)duration);
        }
        catch (InterruptedException ie) {
            throw new IOException("Interrupted while waiting for committer to shutdown", ie);
        }
        finally {
            this._logger.info("Watermark committer: one last commit before shutting down");
            this._watermarkCommitter.run();
        }
    }

    @Override
    public WatermarkManager.CommitStatus getCommitStatus() {
        return this._commitStatus;
    }

    @Override
    public WatermarkManager.RetrievalStatus getRetrievalStatus() {
        return this._retrievalStatus;
    }
}

