/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.gobblin.source.extractor.CheckpointableWatermark;
import org.apache.gobblin.writer.WatermarkTracker;

public class LastWatermarkTracker
implements WatermarkTracker {
    private final Map<String, CheckpointableWatermark> _committedWatermarkMap = new ConcurrentHashMap<String, CheckpointableWatermark>();
    private final Map<String, CheckpointableWatermark> _unackedWatermarkMap;
    private boolean ignoreUnacknowledged;

    public LastWatermarkTracker(boolean ignoreUnacknowledged) {
        this._unackedWatermarkMap = ignoreUnacknowledged ? null : new ConcurrentHashMap<String, CheckpointableWatermark>();
        this.ignoreUnacknowledged = ignoreUnacknowledged;
    }

    @Override
    public void reset() {
        this._committedWatermarkMap.clear();
        if (this._unackedWatermarkMap != null) {
            this._unackedWatermarkMap.clear();
        }
    }

    @Override
    public void committedWatermarks(Map<String, CheckpointableWatermark> committedMap) {
        this._committedWatermarkMap.putAll(committedMap);
    }

    @Override
    public void committedWatermark(CheckpointableWatermark committed) {
        this._committedWatermarkMap.put(committed.getSource(), committed);
    }

    @Override
    public void unacknowledgedWatermark(CheckpointableWatermark unacked) {
        if (this._unackedWatermarkMap != null) {
            this._unackedWatermarkMap.put(unacked.getSource(), unacked);
        }
    }

    @Override
    public void unacknowledgedWatermarks(Map<String, CheckpointableWatermark> unackedMap) {
        if (this._unackedWatermarkMap != null) {
            this._unackedWatermarkMap.putAll(unackedMap);
        }
    }

    @Override
    public Map<String, CheckpointableWatermark> getAllCommitableWatermarks() {
        return new HashMap<String, CheckpointableWatermark>(this._committedWatermarkMap);
    }

    @Override
    public Map<String, CheckpointableWatermark> getAllUnacknowledgedWatermarks() {
        if (this._unackedWatermarkMap != null) {
            return new HashMap<String, CheckpointableWatermark>(this._unackedWatermarkMap);
        }
        return Collections.EMPTY_MAP;
    }
}

