/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer;

import com.codahale.metrics.Meter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.io.Closer;
import com.typesafe.config.Config;
import java.io.Closeable;
import java.io.IOException;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.instrumented.Instrumentable;
import org.apache.gobblin.instrumented.Instrumented;
import org.apache.gobblin.metrics.GobblinMetrics;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.Tag;
import org.apache.gobblin.source.extractor.CheckpointableWatermark;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.gobblin.util.ExecutorsUtils;
import org.apache.gobblin.writer.AcknowledgableWatermark;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class FineGrainedWatermarkTracker
implements Instrumentable,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(FineGrainedWatermarkTracker.class);
    public static final String WATERMARK_TRACKER_SWEEP_INTERVAL_MS = "watermark.tracker.sweepIntervalMillis";
    public static final Long WATERMARK_TRACKER_SWEEP_INTERVAL_MS_DEFAULT = 100L;
    private static final String WATERMARK_TRACKER_STABILITY_CHECK_INTERVAL_MS = "watermark.tracker.stabilityCheckIntervalMillis";
    private static final Long WATERMARK_TRACKER_STABILITY_CHECK_INTERVAL_MS_DEFAULT = 10000L;
    private static final String WATERMARK_TRACKER_LAG_THRESHOLD = "watermark.tracker.lagThreshold";
    private static final Long WATERMARK_TRACKER_LAG_THRESHOLD_DEFAULT = 100000L;
    private static final String WATERMARKS_INSERTED_METER = "watermark.tracker.inserted";
    private static final String WATERMARKS_SWEPT_METER = "watermark.tracker.swept";
    private static final long MILLIS_TO_NANOS = 1000000L;
    private final Map<String, Deque<AcknowledgableWatermark>> _watermarksMap = new HashMap<String, Deque<AcknowledgableWatermark>>();
    private final long _sweepIntervalMillis;
    private final long _stabilityCheckIntervalMillis;
    private final long _watermarkLagThreshold;
    private ScheduledExecutorService _executorService;
    private final boolean _instrumentationEnabled;
    private MetricContext _metricContext;
    protected final Closer _closer;
    private Meter _watermarksInserted;
    private Meter _watermarksSwept;
    private final AtomicBoolean _started;
    private final AtomicBoolean _abort;
    private boolean _autoStart = true;
    private final Runnable _sweeper;
    private final Runnable _stabilityChecker;

    public FineGrainedWatermarkTracker(Config config) {
        this._sweepIntervalMillis = ConfigUtils.getLong((Config)config, (String)WATERMARK_TRACKER_SWEEP_INTERVAL_MS, (Long)WATERMARK_TRACKER_SWEEP_INTERVAL_MS_DEFAULT);
        this._stabilityCheckIntervalMillis = ConfigUtils.getLong((Config)config, (String)WATERMARK_TRACKER_STABILITY_CHECK_INTERVAL_MS, (Long)WATERMARK_TRACKER_STABILITY_CHECK_INTERVAL_MS_DEFAULT);
        this._watermarkLagThreshold = ConfigUtils.getLong((Config)config, (String)WATERMARK_TRACKER_LAG_THRESHOLD, (Long)WATERMARK_TRACKER_LAG_THRESHOLD_DEFAULT);
        this._instrumentationEnabled = GobblinMetrics.isEnabled((Config)config);
        this._closer = Closer.create();
        this._metricContext = (MetricContext)this._closer.register((Closeable)Instrumented.getMetricContext(ConfigUtils.configToState((Config)config), this.getClass()));
        this.regenerateMetrics();
        this._started = new AtomicBoolean(false);
        this._abort = new AtomicBoolean(false);
        this._sweeper = new Runnable(){

            @Override
            public void run() {
                FineGrainedWatermarkTracker.this.sweep();
            }
        };
        this._stabilityChecker = new Runnable(){

            @Override
            public void run() {
                FineGrainedWatermarkTracker.this.checkStability();
            }
        };
    }

    @VisibleForTesting
    void setAutoStart(boolean autoStart) {
        this._autoStart = autoStart;
    }

    public void track(AcknowledgableWatermark acknowledgableWatermark) {
        if (!this._started.get() && this._autoStart) {
            this.start();
        }
        this.maybeAbort();
        String source = acknowledgableWatermark.getCheckpointableWatermark().getSource();
        Deque<AcknowledgableWatermark> sourceWatermarks = this._watermarksMap.get(source);
        if (sourceWatermarks == null) {
            sourceWatermarks = new ConcurrentLinkedDeque<AcknowledgableWatermark>();
            this._watermarksMap.put(source, sourceWatermarks);
        }
        sourceWatermarks.add(acknowledgableWatermark);
        this._watermarksInserted.mark();
    }

    private void maybeAbort() throws RuntimeException {
        if (this._abort.get()) {
            throw new RuntimeException("Aborting Watermark tracking");
        }
    }

    private void checkStability() {
        if (this._watermarksInserted.getCount() - this._watermarksSwept.getCount() > this._watermarkLagThreshold) {
            log.error("Setting abort flag for Watermark tracking because the lag between the watermarksInserted: {} and watermarksSwept: {} is greater than the threshold: {}", new Object[]{this._watermarksInserted.getCount(), this._watermarksSwept.getCount(), this._watermarkLagThreshold});
            this._abort.set(true);
        }
    }

    public Map<String, CheckpointableWatermark> getCommittableWatermarks() {
        HashMap<String, CheckpointableWatermark> commitableWatermarks = new HashMap<String, CheckpointableWatermark>(this._watermarksMap.size());
        for (Map.Entry<String, Deque<AcknowledgableWatermark>> entry : this._watermarksMap.entrySet()) {
            AcknowledgableWatermark watermark;
            String source = entry.getKey();
            Iterable watermarks = entry.getValue();
            AcknowledgableWatermark highestWatermark = null;
            Iterator iterator = watermarks.iterator();
            while (iterator.hasNext() && (watermark = (AcknowledgableWatermark)iterator.next()).isAcked()) {
                highestWatermark = watermark;
            }
            if (highestWatermark == null) continue;
            commitableWatermarks.put(source, highestWatermark.getCheckpointableWatermark());
        }
        return commitableWatermarks;
    }

    public Map<String, CheckpointableWatermark> getUnacknowledgedWatermarks() {
        HashMap<String, CheckpointableWatermark> unackedWatermarks = new HashMap<String, CheckpointableWatermark>(this._watermarksMap.size());
        for (Map.Entry<String, Deque<AcknowledgableWatermark>> entry : this._watermarksMap.entrySet()) {
            String source = entry.getKey();
            Iterable watermarks = entry.getValue();
            AcknowledgableWatermark lowestUnacked = null;
            for (AcknowledgableWatermark watermark : watermarks) {
                if (watermark.isAcked()) continue;
                lowestUnacked = watermark;
                break;
            }
            if (lowestUnacked == null) continue;
            unackedWatermarks.put(source, lowestUnacked.getCheckpointableWatermark());
        }
        return unackedWatermarks;
    }

    public synchronized void start() {
        if (!this._started.get()) {
            this._executorService = new ScheduledThreadPoolExecutor(1, ExecutorsUtils.newThreadFactory((Optional)Optional.of((Object)LoggerFactory.getLogger(FineGrainedWatermarkTracker.class))));
            this._executorService.scheduleAtFixedRate(this._sweeper, 0L, this._sweepIntervalMillis, TimeUnit.MILLISECONDS);
            this._executorService.scheduleAtFixedRate(this._stabilityChecker, 0L, this._stabilityCheckIntervalMillis, TimeUnit.MILLISECONDS);
        }
        this._started.set(true);
    }

    @Override
    public void close() throws IOException {
        try {
            if (this._executorService != null) {
                this._executorService.shutdown();
            }
        }
        finally {
            this._closer.close();
        }
    }

    @VisibleForTesting
    synchronized int sweep() {
        long startTime = System.nanoTime();
        int swept = 0;
        for (Map.Entry<String, Deque<AcknowledgableWatermark>> entry : this._watermarksMap.entrySet()) {
            Deque<AcknowledgableWatermark> watermarks = entry.getValue();
            boolean continueIteration = true;
            while (continueIteration) {
                Iterator<AcknowledgableWatermark> iter = watermarks.iterator();
                if (!iter.hasNext()) {
                    continueIteration = false;
                    continue;
                }
                AcknowledgableWatermark first = iter.next();
                if (first.isAcked()) {
                    if (!iter.hasNext()) {
                        continueIteration = false;
                        continue;
                    }
                    AcknowledgableWatermark second = iter.next();
                    if (second != null && second.isAcked()) {
                        watermarks.pop();
                        ++swept;
                        continue;
                    }
                    continueIteration = false;
                    continue;
                }
                continueIteration = false;
            }
        }
        long duration = (System.nanoTime() - startTime) / 1000000L;
        log.debug("Swept {} watermarks in {} millis", (Object)swept, (Object)duration);
        this._watermarksSwept.mark((long)swept);
        return swept;
    }

    @Override
    public void switchMetricContext(List<Tag<?>> tags) {
        this._metricContext = (MetricContext)this._closer.register((Closeable)Instrumented.newContextFromReferenceContext(this._metricContext, tags, (Optional<String>)Optional.absent()));
        this.regenerateMetrics();
    }

    @Override
    public void switchMetricContext(MetricContext context) {
        this._metricContext = context;
        this.regenerateMetrics();
    }

    @Override
    public List<Tag<?>> generateTags(State state) {
        return Lists.newArrayList();
    }

    @Override
    @Nonnull
    public MetricContext getMetricContext() {
        return this._metricContext;
    }

    @Override
    public boolean isInstrumentationEnabled() {
        return this._instrumentationEnabled;
    }

    protected void regenerateMetrics() {
        this._watermarksInserted = this._metricContext.meter(WATERMARKS_INSERTED_METER);
        this._watermarksSwept = this._metricContext.meter(WATERMARKS_SWEPT_METER);
    }
}

