/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.writer.RecordFuture;
import org.apache.gobblin.writer.RecordMetadata;
import org.apache.gobblin.writer.WriteCallback;
import org.apache.gobblin.writer.WriteResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alpha
public abstract class Batch<D> {
    public static final String BATCH_TTL = "writer.batch.ttl";
    public static final long BATCH_TTL_DEFAULT = 1000L;
    public static final String BATCH_SIZE = "writer.batch.size";
    public static final long BATCH_SIZE_DEFAULT = 262144L;
    public static final String BATCH_QUEUE_CAPACITY = "writer.batch.queue.capacity";
    public static final long BATCH_QUEUE_CAPACITY_DEFAULT = 100L;
    private final List<Thunk> thunks;
    private final long id;
    private long recordCount = 0L;
    private final CountDownLatch latch = new CountDownLatch(1);
    private static AtomicInteger identifier = new AtomicInteger(0);
    private static final Logger LOG = LoggerFactory.getLogger(Batch.class);

    public Batch() {
        this.thunks = new ArrayList<Thunk>();
        this.id = identifier.incrementAndGet();
    }

    public void done() {
        this.latch.countDown();
    }

    public long getId() {
        return this.id;
    }

    public void onSuccess(final WriteResponse response) {
        for (final Thunk thunk : this.thunks) {
            thunk.callback.onSuccess(new WriteResponse(){

                public Object getRawResponse() {
                    return response.getRawResponse();
                }

                @Override
                public String getStringResponse() {
                    return response.getStringResponse();
                }

                @Override
                public long bytesWritten() {
                    return thunk.sizeInBytes;
                }
            });
        }
    }

    public void onFailure(Throwable throwable) {
        for (Thunk thunk : this.thunks) {
            thunk.callback.onFailure(throwable);
        }
    }

    public abstract List<D> getRecords();

    public abstract long getCurrentSizeInByte();

    public abstract boolean hasRoom(D var1);

    public abstract void append(D var1);

    public abstract int getRecordSizeInByte(D var1);

    public Future<RecordMetadata> tryAppend(D record, WriteCallback callback) {
        if (!this.hasRoom(record)) {
            LOG.debug("Cannot add " + record + " to previous batch because the batch already has " + this.getCurrentSizeInByte() + " bytes");
            return null;
        }
        this.append(record);
        this.thunks.add(new Thunk(callback, this.getRecordSizeInByte(record)));
        RecordFuture future = new RecordFuture(this.latch, this.recordCount);
        ++this.recordCount;
        return future;
    }

    public void await() throws InterruptedException {
        this.latch.await();
    }

    private static final class Thunk {
        final WriteCallback callback;
        final int sizeInBytes;

        public Thunk(WriteCallback callback, int sizeInBytes) {
            this.callback = callback;
            this.sizeInBytes = sizeInBytes;
        }
    }
}

