/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.test;

import avro.shaded.com.google.common.base.Throwables;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.gobblin.configuration.SourceState;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.source.Source;
import org.apache.gobblin.source.extractor.CheckpointableWatermark;
import org.apache.gobblin.source.extractor.DataRecordException;
import org.apache.gobblin.source.extractor.DefaultCheckpointableWatermark;
import org.apache.gobblin.source.extractor.Extractor;
import org.apache.gobblin.source.extractor.StreamingExtractor;
import org.apache.gobblin.source.extractor.Watermark;
import org.apache.gobblin.source.extractor.WatermarkInterval;
import org.apache.gobblin.source.extractor.extract.LongWatermark;
import org.apache.gobblin.source.workunit.Extract;
import org.apache.gobblin.source.workunit.ExtractFactory;
import org.apache.gobblin.source.workunit.WorkUnit;
import org.apache.gobblin.stream.RecordEnvelope;
import org.apache.gobblin.test.TestRecord;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.gobblin.writer.WatermarkStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequentialTestSource
implements Source<String, Object> {
    private static final Logger log = LoggerFactory.getLogger(SequentialTestSource.class);
    private static final int DEFAULT_NUM_PARALLELISM = 1;
    private static final String DEFAULT_NAMESPACE = "TestDB";
    private static final String DEFAULT_TABLE = "TestTable";
    private static final Integer DEFAULT_NUM_RECORDS_PER_EXTRACT = 100;
    public static final String WORK_UNIT_INDEX = "workUnitIndex";
    private static final Long DEFAULT_SLEEP_TIME_PER_RECORD_MILLIS = 10L;
    private final AtomicBoolean configured = new AtomicBoolean(false);
    private int num_parallelism;
    private String namespace;
    private String table;
    private int numRecordsPerExtract;
    private long sleepTimePerRecord;
    private final Extract.TableType tableType = Extract.TableType.APPEND_ONLY;
    private final ExtractFactory _extractFactory = new ExtractFactory("yyyyMMddHHmmss");
    private boolean streaming = false;

    private void configureIfNeeded(Config config) {
        if (!this.configured.get()) {
            this.num_parallelism = ConfigUtils.getInt((Config)config, (String)"source.numParallelism", (Integer)1);
            this.namespace = ConfigUtils.getString((Config)config, (String)"source.namespace", (String)DEFAULT_NAMESPACE);
            this.table = ConfigUtils.getString((Config)config, (String)"source.table", (String)DEFAULT_TABLE);
            this.numRecordsPerExtract = ConfigUtils.getInt((Config)config, (String)"source.numRecordsPerExtract", (Integer)DEFAULT_NUM_RECORDS_PER_EXTRACT);
            this.sleepTimePerRecord = ConfigUtils.getLong((Config)config, (String)"source.sleepTimePerRecordMillis", (Long)DEFAULT_SLEEP_TIME_PER_RECORD_MILLIS);
            this.streaming = ConfigUtils.getString((Config)config, (String)"task.executionMode", (String)"BATCH").equalsIgnoreCase("STREAMING");
            if (this.streaming) {
                this.numRecordsPerExtract = Integer.MAX_VALUE;
            }
            this.configured.set(true);
        }
    }

    public List<WorkUnit> getWorkunits(SourceState state) {
        this.configureIfNeeded(ConfigFactory.parseProperties((Properties)state.getProperties()));
        List previousWorkUnitStates = state.getPreviousWorkUnitStates();
        if (!previousWorkUnitStates.isEmpty()) {
            ArrayList newWorkUnits = Lists.newArrayListWithCapacity((int)previousWorkUnitStates.size());
            boolean i = false;
            for (WorkUnitState workUnitState : previousWorkUnitStates) {
                WorkUnit workUnit;
                WatermarkInterval watermarkInterval;
                LongWatermark expectedWatermark;
                LongWatermark watermark;
                if (workUnitState.getWorkingState().equals((Object)WorkUnitState.WorkingState.COMMITTED)) {
                    watermark = (LongWatermark)workUnitState.getActualHighWatermark(LongWatermark.class);
                    expectedWatermark = new LongWatermark(watermark.getValue() + (long)this.numRecordsPerExtract);
                    watermarkInterval = new WatermarkInterval((Watermark)watermark, (Watermark)expectedWatermark);
                    workUnit = WorkUnit.create((Extract)this.newExtract(this.tableType, this.namespace, this.table), (WatermarkInterval)watermarkInterval);
                    log.debug("Will be setting watermark interval to " + watermarkInterval.toJson());
                    workUnit.setProp(WORK_UNIT_INDEX, (Object)workUnitState.getWorkunit().getProp(WORK_UNIT_INDEX));
                } else {
                    watermark = (LongWatermark)workUnitState.getWorkunit().getLowWatermark(LongWatermark.class);
                    expectedWatermark = new LongWatermark(watermark.getValue() + (long)this.numRecordsPerExtract);
                    watermarkInterval = new WatermarkInterval((Watermark)watermark, (Watermark)expectedWatermark);
                    workUnit = WorkUnit.create((Extract)this.newExtract(this.tableType, this.namespace, this.table), (WatermarkInterval)watermarkInterval);
                    log.debug("Will be setting watermark interval to " + watermarkInterval.toJson());
                    workUnit.setProp(WORK_UNIT_INDEX, (Object)workUnitState.getWorkunit().getProp(WORK_UNIT_INDEX));
                }
                newWorkUnits.add(workUnit);
            }
            return newWorkUnits;
        }
        return this.initialWorkUnits();
    }

    private List<WorkUnit> initialWorkUnits() {
        ArrayList workUnits = Lists.newArrayList();
        for (int i = 0; i < this.num_parallelism; ++i) {
            WorkUnit workUnit = WorkUnit.create((Extract)this.newExtract(Extract.TableType.APPEND_ONLY, this.namespace, this.table));
            LongWatermark lowWatermark = new LongWatermark(i * this.numRecordsPerExtract + 1);
            LongWatermark expectedHighWatermark = new LongWatermark((i + 1) * this.numRecordsPerExtract);
            workUnit.setWatermarkInterval(new WatermarkInterval((Watermark)lowWatermark, (Watermark)expectedHighWatermark));
            workUnit.setProp(WORK_UNIT_INDEX, (Object)i);
            workUnits.add(workUnit);
        }
        return workUnits;
    }

    private Extract newExtract(Extract.TableType tableType, String namespace, String table) {
        return this._extractFactory.getUniqueExtract(tableType, namespace, table);
    }

    public Extractor<String, Object> getExtractor(WorkUnitState state) throws IOException {
        Config config = ConfigFactory.parseProperties((Properties)state.getProperties());
        this.configureIfNeeded(config);
        LongWatermark lowWatermark = (LongWatermark)state.getWorkunit().getLowWatermark(LongWatermark.class);
        WorkUnitState workUnitState = state;
        int index = state.getPropAsInt(WORK_UNIT_INDEX);
        TestBatchExtractor extractor = new TestBatchExtractor(index, lowWatermark, this.numRecordsPerExtract, this.sleepTimePerRecord, workUnitState);
        if (!this.streaming) {
            return extractor;
        }
        return new TestStreamingExtractor(extractor);
    }

    public void shutdown(SourceState state) {
    }

    static class TestStreamingExtractor
    implements StreamingExtractor<String, Object> {
        private Optional<WatermarkStorage> watermarkStorage;
        private final TestBatchExtractor extractor;

        public TestStreamingExtractor(TestBatchExtractor extractor) {
            this.extractor = extractor;
        }

        public void close() throws IOException {
            this.extractor.close();
        }

        public String getSchema() throws IOException {
            return this.extractor.getSchema();
        }

        public RecordEnvelope<Object> readRecordEnvelope() throws DataRecordException, IOException {
            TestRecord record = (TestRecord)this.extractor.readRecord(null);
            return new RecordEnvelope((Object)record, (CheckpointableWatermark)new DefaultCheckpointableWatermark("" + record.getPartition(), new LongWatermark(record.getSequence())));
        }

        public long getExpectedRecordCount() {
            return this.extractor.getExpectedRecordCount();
        }

        public long getHighWatermark() {
            return this.extractor.getHighWatermark();
        }

        public void start(WatermarkStorage watermarkStorage) throws IOException {
            Map lastCommitted;
            this.watermarkStorage = Optional.of((Object)watermarkStorage);
            try {
                lastCommitted = ((WatermarkStorage)this.watermarkStorage.get()).getCommittedWatermarks(DefaultCheckpointableWatermark.class, (Iterable)ImmutableList.of((Object)("" + this.extractor.partition)));
            }
            catch (IOException e) {
                log.warn("Failed to get watermarks... will start from the beginning", (Throwable)e);
                lastCommitted = Collections.EMPTY_MAP;
            }
            for (Map.Entry entry : lastCommitted.entrySet()) {
                log.info("{}: Found these committed watermarks: key: {}, value: {}", new Object[]{this, entry.getKey(), entry.getValue()});
            }
            LongWatermark currentWatermark = !lastCommitted.isEmpty() && lastCommitted.containsKey("" + this.extractor.partition) ? (LongWatermark)((CheckpointableWatermark)lastCommitted.get("" + this.extractor.partition)).getWatermark() : new LongWatermark(-1L);
            this.extractor.setCurrentWatermark(currentWatermark);
            log.info("{}: Set current watermark to : {}", (Object)this, (Object)currentWatermark);
        }
    }

    static class TestBatchExtractor
    implements Extractor<String, Object> {
        private long recordsExtracted = 0L;
        private final long numRecordsPerExtract;
        private LongWatermark currentWatermark;
        private long sleepTimePerRecord;
        private int partition;
        WorkUnitState workUnitState;

        public TestBatchExtractor(int partition, LongWatermark lowWatermark, long numRecordsPerExtract, long sleepTimePerRecord, WorkUnitState wuState) {
            this.partition = partition;
            this.currentWatermark = lowWatermark;
            this.numRecordsPerExtract = numRecordsPerExtract;
            this.sleepTimePerRecord = sleepTimePerRecord;
            this.workUnitState = wuState;
        }

        public String getSchema() throws IOException {
            return "";
        }

        public Object readRecord(@Deprecated Object reuse) throws DataRecordException, IOException {
            if (this.recordsExtracted < this.numRecordsPerExtract) {
                try {
                    Thread.sleep(this.sleepTimePerRecord);
                }
                catch (InterruptedException e) {
                    Throwables.propagate((Throwable)e);
                }
                TestRecord record = new TestRecord(this.partition, this.currentWatermark.getValue(), null);
                log.debug("Extracted record -> {}", (Object)record);
                this.currentWatermark.increment();
                ++this.recordsExtracted;
                return record;
            }
            return null;
        }

        public long getExpectedRecordCount() {
            return this.numRecordsPerExtract;
        }

        public long getHighWatermark() {
            return this.workUnitState.getHighWaterMark();
        }

        public void close() throws IOException {
            this.workUnitState.setActualHighWatermark((Watermark)this.currentWatermark);
        }

        public void setCurrentWatermark(LongWatermark currentWatermark) {
            this.currentWatermark = currentWatermark;
        }
    }
}

