/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.test;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.util.Collections;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.Converter;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.converter.SchemaConversionException;
import org.apache.gobblin.util.io.GsonInterfaceAdapter;

public class AnyToJsonConverter
extends Converter<String, String, Object, JsonElement> {
    private static final Gson GSON = GsonInterfaceAdapter.getGson(Object.class);
    private boolean stripTopLevelType = true;

    public String convertSchema(String inputSchema, WorkUnitState workUnit) throws SchemaConversionException {
        return "";
    }

    public Iterable<JsonElement> convertRecord(String outputSchema, Object inputRecord, WorkUnitState workUnit) throws DataConversionException {
        JsonElement jsonElement = GSON.toJsonTree(inputRecord);
        if (this.stripTopLevelType) {
            jsonElement = jsonElement.getAsJsonObject().get("object-data");
        }
        return Collections.singletonList(jsonElement);
    }
}

