/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import org.apache.gobblin.source.extractor.CheckpointableWatermark;
import org.apache.gobblin.source.extractor.ComparableWatermark;
import org.apache.gobblin.source.extractor.Watermark;
import org.apache.gobblin.util.io.GsonInterfaceAdapter;

public class DefaultCheckpointableWatermark
implements CheckpointableWatermark {
    private static final Gson GSON = GsonInterfaceAdapter.getGson(Object.class);
    private final String source;
    private final ComparableWatermark comparable;

    public DefaultCheckpointableWatermark(String source, ComparableWatermark comparableWatermark) {
        this.source = source;
        this.comparable = comparableWatermark;
    }

    public String getSource() {
        return this.source;
    }

    public ComparableWatermark getWatermark() {
        return this.comparable;
    }

    public int compareTo(CheckpointableWatermark o) {
        if (!this.source.equals(o.getSource())) {
            throw new RuntimeException("Could not compare two checkpointable watermarks because they have different sources " + this.source + ":" + o.getSource());
        }
        return this.comparable.compareTo((Object)o.getWatermark());
    }

    public JsonElement toJson() {
        return GSON.toJsonTree((Object)this);
    }

    public short calculatePercentCompletion(Watermark lowWatermark, Watermark highWatermark) {
        return this.comparable.calculatePercentCompletion(lowWatermark, highWatermark);
    }

    public String toString() {
        return String.format("%s : %s ", this.getSource(), GSON.toJson(this.comparable.toJson()));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultCheckpointableWatermark)) {
            return false;
        }
        DefaultCheckpointableWatermark other = (DefaultCheckpointableWatermark)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        ComparableWatermark this$comparable = this.comparable;
        ComparableWatermark other$comparable = other.comparable;
        return !(this$comparable == null ? other$comparable != null : !this$comparable.equals(other$comparable));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultCheckpointableWatermark;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        ComparableWatermark $comparable = this.comparable;
        result = result * 59 + ($comparable == null ? 43 : $comparable.hashCode());
        return result;
    }
}

