/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.instrumented.converter;

import java.io.IOException;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.Converter;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.converter.SchemaConversionException;
import org.apache.gobblin.instrumented.Instrumented;
import org.apache.gobblin.instrumented.converter.InstrumentedConverterBase;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.records.ControlMessageHandler;
import org.apache.gobblin.records.RecordStreamWithMetadata;
import org.apache.gobblin.util.Decorator;
import org.apache.gobblin.util.DecoratorUtils;

public class InstrumentedConverterDecorator<SI, SO, DI, DO>
extends InstrumentedConverterBase<SI, SO, DI, DO>
implements Decorator {
    private Converter<SI, SO, DI, DO> embeddedConverter;
    private final boolean isEmbeddedInstrumented;

    public InstrumentedConverterDecorator(Converter<SI, SO, DI, DO> converter) {
        this.embeddedConverter = converter;
        this.isEmbeddedInstrumented = Instrumented.isLineageInstrumented(converter);
    }

    @Override
    public Converter<SI, SO, DI, DO> init(WorkUnitState workUnit) {
        this.embeddedConverter = this.embeddedConverter.init(workUnit);
        return super.init(workUnit, DecoratorUtils.resolveUnderlyingObject((Object)this).getClass());
    }

    @Override
    public MetricContext getMetricContext() {
        return this.isEmbeddedInstrumented ? ((InstrumentedConverterBase)this.embeddedConverter).getMetricContext() : super.getMetricContext();
    }

    @Override
    public Iterable<DO> convertRecord(SO outputSchema, DI inputRecord, WorkUnitState workUnit) throws DataConversionException {
        return this.isEmbeddedInstrumented ? this.convertRecordImpl(outputSchema, inputRecord, workUnit) : super.convertRecord(outputSchema, inputRecord, workUnit);
    }

    @Override
    public Iterable<DO> convertRecordImpl(SO outputSchema, DI inputRecord, WorkUnitState workUnit) throws DataConversionException {
        return this.embeddedConverter.convertRecord(outputSchema, inputRecord, workUnit);
    }

    public SO convertSchema(SI inputSchema, WorkUnitState workUnit) throws SchemaConversionException {
        return (SO)this.embeddedConverter.convertSchema(inputSchema, workUnit);
    }

    @Override
    public void close() throws IOException {
        this.embeddedConverter.close();
    }

    public State getFinalState() {
        return this.embeddedConverter.getFinalState();
    }

    public Object getDecoratedObject() {
        return this.embeddedConverter;
    }

    public RecordStreamWithMetadata<DO, SO> processStream(RecordStreamWithMetadata<DI, SI> inputStream, WorkUnitState workUnitState) throws SchemaConversionException {
        return this.embeddedConverter.processStream(inputStream, workUnitState);
    }

    public ControlMessageHandler getMessageHandler() {
        return this.embeddedConverter.getMessageHandler();
    }
}

