/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.crypto;

import java.util.Map;
import java.util.ServiceLoader;
import org.apache.gobblin.codec.StreamCodec;
import org.apache.gobblin.crypto.EncryptionConfigParser;
import org.apache.gobblin.crypto.EncryptionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptionFactory {
    private static final Logger log = LoggerFactory.getLogger(EncryptionFactory.class);
    private static final Object $LOCK = new Object[0];
    private static ServiceLoader<EncryptionProvider> encryptionProviderLoader = ServiceLoader.load(EncryptionProvider.class);

    public static StreamCodec buildStreamCryptoProvider(Map<String, Object> parameters) {
        String encryptionType = EncryptionConfigParser.getEncryptionType(parameters);
        if (encryptionType == null) {
            throw new IllegalArgumentException("Encryption type not present in parameters!");
        }
        return EncryptionFactory.buildStreamCryptoProvider(encryptionType, parameters);
    }

    public static StreamCodec buildStreamCryptoProvider(String algorithm, Map<String, Object> parameters) {
        Object object = $LOCK;
        synchronized (object) {
            for (EncryptionProvider provider : encryptionProviderLoader) {
                log.debug("Looking for algorithm {} in provider {}", (Object)algorithm, (Object)provider.getClass().getName());
                StreamCodec codec = provider.buildStreamCryptoProvider(algorithm, parameters);
                if (codec == null) continue;
                log.debug("Found algorithm {} in provider {}", (Object)algorithm, (Object)provider.getClass().getName());
                return codec;
            }
            throw new IllegalArgumentException("Could not find a provider to build algorithm " + algorithm + " - is gobblin-crypto-provider in classpath?");
        }
    }
}

